package com.biz.crm.tpm.business.promotion.plan.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 采销库存导入vo
 *
 * @author: yaoyongming
 * @date: 2023/1/11 9:18
 */
@Data
@CrmExcelImport(startRow = 2)
public class PurchaseSaleImportsVo extends CrmExcelVo {

    /**
     * 产品编码
     */
    @CrmExcelColumn("*产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmExcelColumn("产品名称")
    private String productName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String productBrandName;


    /**
     * 标准零售价
     */
    @ApiModelProperty("标准零售价")
    private BigDecimal standardRetailPrice;

    /**
     * 供货价
     */
    @ApiModelProperty("供货价")
    private BigDecimal supplyPrice;

    /**
     * 本月期末库存（箱）
     */
    @CrmExcelColumn("*本月期末库存（箱）")
    private BigDecimal monthInventoryEnd;

    /**
     * 原 促销售价（元）
     * 现 本月库存预估价（元）
     */
    @CrmExcelColumn("*本月库存预估价（元）")
    private BigDecimal promotionPrice;

    /**
     * 次月期末库存（箱）
     */
    @CrmExcelColumn("次月期末库存（箱）")
    private String nextMonthEndInventoryStr;

    /**
     * 次月期末库存（箱）
     */
    @ApiModelProperty("次月期末库存（箱）")
    private BigDecimal nextMonthEndInventory;

    /**
     * 次月库存预估售价（元）
     */
    @CrmExcelColumn("*次月库存预估售价（元）")
    private String nextMonthInventoryAmountStr;

    /**
     * 次月库存预估售价（元）
     */
    @ApiModelProperty("次月库存预估售价（元）")
    private BigDecimal nextMonthInventoryAmount;

    /**
     * 费用池-补差
     */
    @CrmExcelColumn("费用池-补差")
    private BigDecimal feePoolDifference;

    /**
     * 费用池-销售返
     */
    @CrmExcelColumn("费用池-销售返")
    private BigDecimal feePoolSaleCommission;

    /**
     * 费用池-采购返
     */
    @CrmExcelColumn("费用池-采购返")
    private BigDecimal feePoolPurchaseRebate;

    /**
     * 费用池-投放
     */
    @CrmExcelColumn("费用池-投放")
    private BigDecimal feePoolPut;

    /**
     * 费用池-毛保
     */
    @CrmExcelColumn("费用池-毛保")
    private BigDecimal feePoolGrossProtection;

    @ApiModelProperty("MDG客户编码")
    private String erpCode;

    /**
     * 红线价
     */
    @ApiModelProperty("红线价")
    private BigDecimal redLinePrice;


    /**
     * 成本价
     */
    @ApiModelProperty("成本价")
    private BigDecimal costPrice;

    private String id;
    private String delFlag;
    private String enableStatus;
    private String remark;
    private String tenantCode;
}
