/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.policy.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.promotion.policy.local.service.PromotionPolicyGiftService;
import com.biz.crm.tpm.business.promotion.policy.local.service.PromotionPolicyProductService;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyLadderDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyProductDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.service.PromotionPolicyService;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyLadderVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyProductVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/promotionPolicy"})
@Api(tags={"\u4fc3\u9500\u653f\u7b56\u7ba1\u7406"})
public class PromotionPolicyController {
    private static final Logger log = LoggerFactory.getLogger(PromotionPolicyController.class);
    @Autowired
    private PromotionPolicyService promotionPolicyService;
    @Autowired
    private PromotionPolicyProductService promotionPolicyProductService;
    @Autowired
    private PromotionPolicyGiftService promotionPolicyGiftService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u4fc3\u9500\u653f\u7b56")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<PromotionPolicyVO>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=20) Pageable pageable, @ApiParam(name="promotionPolicy", value="\u4fc3\u9500\u653f\u7b56\u7ba1\u7406") PromotionPolicyDto promotionPolicy) {
        try {
            Page page = this.promotionPolicyService.findByConditions(pageable, promotionPolicy);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952eID \u67e5\u8be2\u4fc3\u9500\u653f\u7b56\u8be6\u60c5")
    @GetMapping(value={"/findById"})
    public Result<PromotionPolicyVO> findById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            PromotionPolicyVO keyIndicatorsVO = this.promotionPolicyService.findByIdOrPromotionCode(id, null);
            return Result.ok((Object)keyIndicatorsVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4fc3\u9500\u7f16\u7801 \u67e5\u8be2\u4fc3\u9500\u653f\u7b56\u8be6\u60c5")
    @GetMapping(value={"/findByPromotionCode"})
    public Result<PromotionPolicyVO> findByPromotionCode(@RequestParam(value="promotionCode") @ApiParam(name="promotionCode", value="\u4fc3\u9500\u7f16\u7801") String promotionCode) {
        try {
            PromotionPolicyVO keyIndicatorsVO = this.promotionPolicyService.findByIdOrPromotionCode(null, promotionCode);
            return Result.ok((Object)keyIndicatorsVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u653f\u7b56")
    @PostMapping(value={"/create"})
    public Result<?> create(@ApiParam(name="promotionPolicy", value="\u4fc3\u9500\u653f\u7b56\u7ba1\u7406") @RequestBody PromotionPolicyDto promotionPolicy) {
        try {
            this.promotionPolicyService.create(promotionPolicy);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u4fc3\u9500\u653f\u7b56")
    @PatchMapping(value={"/update"})
    public Result<?> update(@ApiParam(name="promotionPolicy", value="\u4fc3\u9500\u653f\u7b56") @RequestBody PromotionPolicyDto promotionPolicy) {
        try {
            this.promotionPolicyService.update(promotionPolicy);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u4fc3\u9500\u653f\u7b56")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.promotionPolicyService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.promotionPolicyService.updateEnableStatus(ids, EnableStatusEnum.ENABLE.getCode());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> ids) {
        try {
            this.promotionPolicyService.updateEnableStatus(ids, EnableStatusEnum.DISABLE.getCode());
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u672c\u54c1")
    @DeleteMapping(value={"/deleteProduct"})
    public Result<?> deleteProduct(@ApiParam(name="promotionCode", value="\u4fc3\u9500\u7f16\u7801") @RequestParam(value="promotionCode") String promotionCode, @ApiParam(name="ids", value="\u672c\u54c1\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.promotionPolicyProductService.deleteProduct(promotionCode, ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e&\u4fee\u6539\u672c\u54c1")
    @PostMapping(value={"/addProduct"})
    public Result<Collection<PromotionPolicyProductVO>> addProduct(@ApiParam(name="promotionCode", value="\u4fc3\u9500\u7f16\u7801") @RequestParam(value="promotionCode") String promotionCode, @ApiParam(name="productList", value="\u672c\u54c1\u96c6\u5408") @RequestBody List<PromotionPolicyProductDto> productList) {
        try {
            Collection promotionPolicyProducts = this.promotionPolicyService.addProducts(promotionCode, productList);
            return Result.ok((Object)promotionPolicyProducts);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u9636\u68af")
    @DeleteMapping(value={"/deleteLadder"})
    public Result<?> deleteLadder(@ApiParam(name="promotionCode", value="\u4fc3\u9500\u7f16\u7801") @RequestParam(value="promotionCode") String promotionCode, @ApiParam(name="ladderCode", value="\u9636\u68af\u7f16\u7801") @RequestParam(value="ladderCode") String ladderCode) {
        try {
            this.promotionPolicyService.deleteLadder(promotionCode, ladderCode);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e&\u4fee\u6539\u9636\u68af (\u642d\u8d60\u7c7b\u578b\u65b0\u589e\u8d60\u54c1)")
    @PostMapping(value={"/addLadder"})
    public Result<Collection<PromotionPolicyLadderVO>> addLadder(@ApiParam(name="promotionCode", value="\u4fc3\u9500\u7f16\u7801") @RequestParam(value="promotionCode") String promotionCode, @ApiParam(name="ladderList", value="\u9636\u68af\u96c6\u5408") @RequestBody List<PromotionPolicyLadderDto> ladderList) {
        try {
            Collection promotionPolicyProducts = this.promotionPolicyService.addLadder(promotionCode, ladderList);
            return Result.ok((Object)promotionPolicyProducts);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u8d60\u54c1")
    @DeleteMapping(value={"/deleteGift"})
    public Result<?> deleteGift(@ApiParam(name="promotionCode", value="\u4fc3\u9500\u7f16\u7801") @RequestParam(value="promotionCode") String promotionCode, @ApiParam(name="productCode", value="\u8d60\u54c1\u7f16\u7801") @RequestParam(value="productCode") String productCode) {
        try {
            this.promotionPolicyService.deleteGift(promotionCode, productCode);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u7535\u5546\u6346\u7ed1")
    @PostMapping(value={"/createEcommerce"})
    public Result<?> createEcommerce(@ApiParam(name="promotionPolicy", value="\u4fc3\u9500\u653f\u7b56\u7ba1\u7406") @RequestBody PromotionPolicyDto promotionPolicy) {
        try {
            this.promotionPolicyService.createEcommerce(promotionPolicy);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7535\u5546\u6346\u7ed1")
    @PatchMapping(value={"/updateEcommerce"})
    public Result<?> updateEcommerce(@ApiParam(name="promotionPolicy", value="\u4fc3\u9500\u653f\u7b56") @RequestBody PromotionPolicyDto promotionPolicy) {
        try {
            this.promotionPolicyService.updateEcommerce(promotionPolicy);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

