/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.policy.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.promotion.policy.local.entity.PromotionPolicy;
import com.biz.crm.tpm.business.promotion.policy.local.mapper.PromotionPolicyMapper;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyProductVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PromotionPolicyRepository
extends ServiceImpl<PromotionPolicyMapper, PromotionPolicy> {
    @Resource
    private PromotionPolicyMapper promotionPolicyMapper;

    public Page<PromotionPolicyVO> findByConditions(Pageable pageable, PromotionPolicyDto promotionPolicy) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)50);
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.promotionPolicyMapper.findByConditions((Page<PromotionPolicyVO>)page, promotionPolicy);
    }

    public List<PromotionPolicyProductVO> findForDistributionCustomerMonthSale(String promotionType, List<String> productCodeList, String lastMonth) {
        return this.promotionPolicyMapper.findForDistributionCustomerMonthSale(promotionType, productCodeList, lastMonth);
    }

    public List<PromotionPolicyVO> findListByYearMonth(String yearMonth) {
        return ((PromotionPolicyMapper)this.baseMapper).findListByYearMonth(yearMonth, TenantUtils.getTenantCode());
    }

    public List<PromotionPolicy> findPolicyByPromotionCodes(List<String> promotionCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(PromotionPolicy::getPromotionCode, promotionCodes)).list();
    }

    public List<PromotionPolicy> hasRelationPolicyConfig(List<String> configCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(PromotionPolicy::getTemplateCode, configCodes)).list();
    }
}

