/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.policy.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.policy.local.entity.PromotionPolicyGift;
import com.biz.crm.tpm.business.promotion.policy.local.repository.PromotionPolicyGiftRepository;
import com.biz.crm.tpm.business.promotion.policy.local.service.PromotionPolicyGiftService;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyGiftDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyGiftVO;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="promotionPolicyGiftService")
public class PromotionPolicyGiftServiceImpl
implements PromotionPolicyGiftService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPolicyGiftServiceImpl.class);
    @Autowired
    private PromotionPolicyGiftRepository promotionPolicyGiftRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<PromotionPolicyGiftVO> findGifts(String promotionCode, String ladderCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        wrapper.eq((Object)"ladder_code", (Object)ladderCode);
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
        List giftEntityList = this.promotionPolicyGiftRepository.list((Wrapper)wrapper);
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)giftEntityList, PromotionPolicyGift.class, PromotionPolicyGiftVO.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(List<PromotionPolicyGiftDto> giftList) {
        if (giftList != null && giftList.size() > 0) {
            ArrayList giftEntityList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(giftList, PromotionPolicyGiftDto.class, PromotionPolicyGift.class, HashSet.class, ArrayList.class, new String[0]));
            this.promotionPolicyGiftRepository.saveOrUpdateBatch(giftEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPromotionCode(List<String> promotionCodes) {
        if (promotionCodes != null && promotionCodes.size() > 0) {
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
            wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
            wrapper.in((Object)"promotion_code", promotionCodes);
            this.promotionPolicyGiftRepository.update((Wrapper)wrapper);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteGiftByLadderCode(String promotionCode, String ladderCode) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)promotionCode) && !StringUtils.isBlank((CharSequence)ladderCode) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u653f\u7b56\u6216\u9636\u68af\uff01", (Object[])new Object[0]);
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        wrapper.eq((Object)"ladder_code", (Object)ladderCode);
        this.promotionPolicyGiftRepository.update((Wrapper)wrapper);
    }

    @Override
    public void deleteGiftByProductCode(String promotionCode, String productCode) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)promotionCode) && !StringUtils.isBlank((CharSequence)productCode) ? 1 : 0) != 0, (String)"\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u6216\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        wrapper.eq((Object)"product_code", (Object)productCode);
        this.promotionPolicyGiftRepository.update((Wrapper)wrapper);
    }
}

