/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.policy.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.policy.local.entity.PromotionPolicy;
import com.biz.crm.tpm.business.promotion.policy.local.entity.PromotionPolicyLadder;
import com.biz.crm.tpm.business.promotion.policy.local.repository.PromotionPolicyLadderRepository;
import com.biz.crm.tpm.business.promotion.policy.local.service.PromotionPolicyGiftService;
import com.biz.crm.tpm.business.promotion.policy.local.service.PromotionPolicyLadderService;
import com.biz.crm.tpm.business.promotion.policy.sdk.enums.PromotionTypeEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyLadderVO;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="promotionPolicyPriceLadderService")
public class PromotionPolicyLadderServiceImpl
implements PromotionPolicyLadderService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPolicyLadderServiceImpl.class);
    @Autowired
    private PromotionPolicyLadderRepository promotionPolicyLadderRepository;
    @Autowired
    private PromotionPolicyGiftService promotionPolicyGiftService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<PromotionPolicyLadderVO> findByPromotionCode(String promotionCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.orderByAsc((Object)"successively");
        List ladderEntityList = this.promotionPolicyLadderRepository.list((Wrapper)wrapper);
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)ladderEntityList, PromotionPolicyLadder.class, PromotionPolicyLadderVO.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(List<PromotionPolicyLadderVO> ladderList) {
        if (ladderList != null && ladderList.size() > 0) {
            ArrayList priceLadderList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(ladderList, PromotionPolicyLadderVO.class, PromotionPolicyLadder.class, HashSet.class, ArrayList.class, new String[0]));
            this.promotionPolicyLadderRepository.saveBatch(priceLadderList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPromotionCode(List<String> promotionCode) {
        if (promotionCode != null && promotionCode.size() > 0) {
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
            wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
            wrapper.in((Object)"promotion_code", promotionCode);
            this.promotionPolicyLadderRepository.update((Wrapper)wrapper);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteLadder(PromotionPolicy promotionPolicy, String ladderCode) {
        Validate.notNull((Object)((Object)promotionPolicy), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u653f\u7b56\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)ladderCode, (String)"\u9636\u68af\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UpdateWrapper wrapper1 = new UpdateWrapper();
        wrapper1.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
        wrapper1.set((Object)"successively", null);
        wrapper1.eq((Object)"tenant_code", (Object)promotionPolicy.getTenantCode());
        wrapper1.eq((Object)"promotion_code", (Object)promotionPolicy.getPromotionCode());
        wrapper1.eq((Object)"ladder_code", (Object)ladderCode);
        boolean result = this.promotionPolicyLadderRepository.update((Wrapper)wrapper1);
        if (result) {
            QueryWrapper wrapper2 = new QueryWrapper();
            wrapper2.eq((Object)"promotion_code", (Object)promotionPolicy.getPromotionCode());
            wrapper2.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
            wrapper2.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
            wrapper2.orderByAsc((Object)"successively");
            List ladderEntityList = this.promotionPolicyLadderRepository.list((Wrapper)wrapper2);
            List ladderCodes = ladderEntityList.stream().map(PromotionPolicyLadder::getLadderCode).filter(Objects::nonNull).collect(Collectors.toList());
            if (ladderEntityList.size() > 0 && ladderEntityList != null) {
                for (int i = 0; i < ladderEntityList.size(); ++i) {
                    ((PromotionPolicyLadder)((Object)ladderEntityList.get(i))).setSuccessively(i + 1);
                }
                this.promotionPolicyLadderRepository.updateBatchById(ladderEntityList);
            }
            if (PromotionTypeEnum.GIFT.getCode().equals(promotionPolicy.getPromotionTypeCode())) {
                this.promotionPolicyGiftService.deleteGiftByLadderCode(promotionPolicy.getPromotionCode(), ladderCode);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(List<PromotionPolicyLadderVO> ladderList) {
        if (ladderList != null) {
            Collection ladders = this.nebulaToolkitService.copyCollectionByWhiteList(ladderList, PromotionPolicyLadderVO.class, PromotionPolicyLadder.class, HashSet.class, ArrayList.class, new String[0]);
            this.promotionPolicyLadderRepository.saveOrUpdateBatch(ladders);
        }
    }
}

