/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.policy.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.promotion.policy.local.entity.PromotionPolicyProduct;
import com.biz.crm.tpm.business.promotion.policy.local.repository.PromotionPolicyProductRepository;
import com.biz.crm.tpm.business.promotion.policy.local.service.PromotionPolicyProductService;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyProductDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyProductVO;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="promotionPolicyProductService")
public class PromotionPolicyProductServiceImpl
implements PromotionPolicyProductService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPolicyProductServiceImpl.class);
    @Autowired
    private PromotionPolicyProductRepository promotionPolicyProductRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<PromotionPolicyProductVO> findByPromotionCode(String promotionCode) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
        List productEntityList = this.promotionPolicyProductRepository.list((Wrapper)wrapper);
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)productEntityList, PromotionPolicyProduct.class, PromotionPolicyProductVO.class, HashSet.class, ArrayList.class, new String[0]));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void create(List<PromotionPolicyProductDto> promotionPolicyProductList) {
        if (promotionPolicyProductList != null) {
            ArrayList productEntityList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(promotionPolicyProductList, PromotionPolicyProductDto.class, PromotionPolicyProduct.class, HashSet.class, ArrayList.class, new String[0]));
            this.promotionPolicyProductRepository.saveBatch(productEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdate(List<PromotionPolicyProductDto> productList) {
        if (productList != null && productList.size() > 0) {
            ArrayList productEntityList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(productList, PromotionPolicyProductDto.class, PromotionPolicyProduct.class, HashSet.class, ArrayList.class, new String[0]));
            this.promotionPolicyProductRepository.saveOrUpdateBatch(productEntityList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByPromotionCode(List<String> promotionCode) {
        if (promotionCode != null && promotionCode.size() > 0) {
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
            wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
            wrapper.in((Object)"promotion_code", promotionCode);
            this.promotionPolicyProductRepository.update((Wrapper)wrapper);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteProduct(String promotionCode, List<String> ids) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)promotionCode) && ids != null ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u672c\u54c1\u6216\u653f\u7b56", (Object[])new Object[0]);
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.in((Object)"id", ids);
        this.promotionPolicyProductRepository.update((Wrapper)wrapper);
    }

    @Override
    public List<PromotionPolicyProduct> findProductInSameDate(Set<String> promotionCodes) {
        if (!CollectionUtils.isEmpty(promotionCodes)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
            wrapper.in((Object)"promotion_code", promotionCodes);
            List productList = this.promotionPolicyProductRepository.list((Wrapper)wrapper);
            return productList;
        }
        return null;
    }
}

