/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.policy.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.vo.UuidVo;
import com.biz.crm.tpm.business.promotion.policy.local.entity.PromotionPolicy;
import com.biz.crm.tpm.business.promotion.policy.local.entity.PromotionPolicyProduct;
import com.biz.crm.tpm.business.promotion.policy.local.repository.PromotionPolicyRepository;
import com.biz.crm.tpm.business.promotion.policy.local.service.PromotionPolicyGiftService;
import com.biz.crm.tpm.business.promotion.policy.local.service.PromotionPolicyLadderService;
import com.biz.crm.tpm.business.promotion.policy.local.service.PromotionPolicyProductService;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyGiftDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyLadderDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyProductDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.PromotionPolicyToSubActDesignEventDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.RelationPolicySelectDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.dto.log.PromotionPolicyLogEventDto;
import com.biz.crm.tpm.business.promotion.policy.sdk.enums.CalculationRulesEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.enums.MeetConditionsEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.enums.PromotionProductTypeEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.enums.PromotionTypeEnum;
import com.biz.crm.tpm.business.promotion.policy.sdk.event.log.PromotionPolicyLogEventListener;
import com.biz.crm.tpm.business.promotion.policy.sdk.event.log.PromotionPolicyToSubActDesignListener;
import com.biz.crm.tpm.business.promotion.policy.sdk.service.PromotionPolicyService;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyGiftVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyLadderVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyProductVO;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.model.EventResponse;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="promotionPolicyService")
public class PromotionPolicyServiceImpl
implements PromotionPolicyService {
    private static final Logger log = LoggerFactory.getLogger(PromotionPolicyServiceImpl.class);
    @Autowired(required=false)
    private PromotionPolicyRepository promotionPolicyRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private PromotionPolicyProductService promotionPolicyProductService;
    @Autowired(required=false)
    private PromotionPolicyLadderService promotionPolicyLadderService;
    @Autowired(required=false)
    private PromotionPolicyGiftService promotionPolicyGiftService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<PromotionPolicyVO> findByConditions(Pageable pageable, PromotionPolicyDto promotionPolicy) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)20);
        }
        if (promotionPolicy == null) {
            promotionPolicy = new PromotionPolicyDto();
        }
        if (StringUtils.isBlank((CharSequence)promotionPolicy.getDelFlag())) {
            promotionPolicy.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)promotionPolicy.getTenantCode())) {
            promotionPolicy.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.promotionPolicyRepository.findByConditions(pageable, promotionPolicy);
    }

    public PromotionPolicyVO findByIdOrPromotionCode(String id, String promotionCode) {
        QueryWrapper wrapper;
        PromotionPolicy dbPromotionPolicy = null;
        if (!StringUtils.isBlank((CharSequence)id)) {
            wrapper = new QueryWrapper();
            wrapper.eq((Object)"id", (Object)id);
            wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
            dbPromotionPolicy = (PromotionPolicy)((Object)this.promotionPolicyRepository.getOne((Wrapper)wrapper));
        } else if (!StringUtils.isBlank((CharSequence)promotionCode)) {
            wrapper = new QueryWrapper();
            wrapper.eq((Object)"promotion_code", (Object)promotionCode);
            wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
            dbPromotionPolicy = (PromotionPolicy)((Object)this.promotionPolicyRepository.getOne((Wrapper)wrapper));
        }
        if (dbPromotionPolicy != null) {
            PromotionPolicyVO promotionPolicyVO = (PromotionPolicyVO)this.nebulaToolkitService.copyObjectByWhiteList(dbPromotionPolicy, PromotionPolicyVO.class, HashSet.class, ArrayList.class, new String[0]);
            List<PromotionPolicyProductVO> productVoList = this.promotionPolicyProductService.findByPromotionCode(dbPromotionPolicy.getPromotionCode());
            List<PromotionPolicyLadderVO> ladderVoList = this.promotionPolicyLadderService.findByPromotionCode(dbPromotionPolicy.getPromotionCode());
            if (PromotionTypeEnum.GIFT.getCode().equals(dbPromotionPolicy.getPromotionTypeCode())) {
                ladderVoList.forEach(ladder -> {
                    List<PromotionPolicyGiftVO> giftVoList = this.promotionPolicyGiftService.findGifts(ladder.getPromotionCode(), ladder.getLadderCode());
                    ladder.setPromotionPolicyGiftList(giftVoList);
                });
            }
            promotionPolicyVO.setPromotionPolicyProducts(productVoList);
            promotionPolicyVO.setPromotionPolicyLadders(ladderVoList);
            return promotionPolicyVO;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(PromotionPolicyDto promotionPolicy) {
        this.createOrUpdateValidate(promotionPolicy);
        promotionPolicy.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        promotionPolicy.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        promotionPolicy.setTenantCode(TenantUtils.getTenantCode());
        String promotionCode = (String)this.generateCodeService.generateCode("CX", 1, Integer.valueOf(3), 2L, TimeUnit.DAYS).get(0);
        Validate.notBlank((CharSequence)promotionCode, (String)"\u4fc3\u9500\u7f16\u53f7\u751f\u6210\u5931\u8d25", (Object[])new Object[0]);
        promotionPolicy.setPromotionCode(promotionCode);
        PromotionPolicy entity = (PromotionPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPolicy, PromotionPolicy.class, HashSet.class, ArrayList.class, new String[0]));
        promotionPolicy.getPromotionPolicyProducts().forEach(productDto -> {
            Validate.notBlank((CharSequence)productDto.getProductCode(), (String)"\u672c\u54c1\u7f16\u7801\u4e0d\u80fd\u591f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)productDto.getProductName(), (String)"\u672c\u54c1\u540d\u79f0\u4e0d\u80fd\u591f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)productDto.getSaleUnit(), (String)"\u672c\u54c1\u9500\u552e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            productDto.setPromotionCode(promotionCode);
            productDto.setDelFlag(promotionPolicy.getDelFlag());
            productDto.setTenantCode(promotionPolicy.getTenantCode());
        });
        if (!promotionPolicy.getPromotionProductType().equals(PromotionProductTypeEnum.GROUP_SPECIAL_PRICE.getCode())) {
            List ladderList = promotionPolicy.getPromotionPolicyLadders();
            this.priceOrQuantityValidate(ladderList);
            List ladders = (List)this.buildLadder(promotionPolicy, ladderList);
            this.promotionPolicyLadderService.create(ladders);
        }
        PromotionPolicyLogEventDto logEventDto = new PromotionPolicyLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(promotionPolicy);
        SerializableBiConsumer & Serializable onCreate = PromotionPolicyLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PromotionPolicyLogEventListener.class, (SerializableBiConsumer)onCreate);
        this.promotionPolicyProductService.create(promotionPolicy.getPromotionPolicyProducts());
        this.promotionPolicyRepository.save((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public Collection<PromotionPolicyLadderVO> buildLadder(PromotionPolicyDto promotionPolicy, List<PromotionPolicyLadderDto> ladderList) {
        ArrayList<PromotionPolicyLadderVO> ladderVoList = new ArrayList<PromotionPolicyLadderVO>();
        for (int i = 0; i < ladderList.size(); ++i) {
            PromotionPolicyLadderDto ladder = ladderList.get(i);
            if (StringUtils.isBlank((CharSequence)ladder.getLadderCode())) {
                String ladderRuleCode = "JT";
                String ladderCode = (String)this.generateCodeService.generateCode(ladderRuleCode, 1, Integer.valueOf(3), 2L, TimeUnit.DAYS).get(0);
                Validate.notBlank((CharSequence)ladderCode, (String)"\u9636\u68af\u7f16\u53f7\u751f\u6210\u5931\u8d25", (Object[])new Object[0]);
                ladder.setLadderCode(ladderCode);
                ladder.setPromotionCode(promotionPolicy.getPromotionCode());
                ladder.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                ladder.setTenantCode(promotionPolicy.getTenantCode());
            }
            if (i + 1 < ladderList.size() && ladderList.size() > 1) {
                BigDecimal after2;
                BigDecimal front2;
                BigDecimal front1 = ladder.getMeetPriceOrQuantity();
                BigDecimal after1 = ladderList.get(i + 1).getMeetPriceOrQuantity();
                Validate.isTrue((after1.compareTo(front1) > 0 ? 1 : 0) != 0, (String)"\u540e\u9636\u68af\u7684\u6ee1\u8db3\u91d1\u989d\u6216\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u524d\u9636\u68af\u7684\u6ee1\u8db3\u91d1\u989d\u6216\u6570\u91cf", (Object[])new Object[0]);
                if (MeetConditionsEnum.SINGLE_SPECIAL_PRICE_MMXSP.getCode().equals(promotionPolicy.getMeetConditions()) || MeetConditionsEnum.SINGLE_SPECIAL_PRICE_MQXSP.getCode().equals(promotionPolicy.getMeetConditions())) {
                    front2 = ladderList.get(i).getGivePriceOrQuantity();
                    after2 = ladderList.get(i + 1).getGivePriceOrQuantity();
                    Validate.isTrue((after2.compareTo(front2) < 0 ? 1 : 0) != 0, (String)"\u540e\u9636\u68af\u7684\u7279\u4ef7\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u524d\u9636\u68af\u7684\u7279\u4ef7\u91d1\u989d", (Object[])new Object[0]);
                } else if (MeetConditionsEnum.UNIT_PRICE_MINUS_MMXFD.getCode().equals(promotionPolicy.getMeetConditions()) || MeetConditionsEnum.UNIT_PRICE_MINUS_MQXFD.getCode().equals(promotionPolicy.getMeetConditions())) {
                    front2 = ladderList.get(i).getGivePriceOrQuantity();
                    after2 = ladderList.get(i + 1).getGivePriceOrQuantity();
                    Validate.isTrue((after2.compareTo(front2) > 0 ? 1 : 0) != 0, (String)"\u540e\u9636\u68af\u7684\u5355\u4ef7\u51cf\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u524d\u9636\u68af\u7684\u5355\u4ef7\u51cf\u91d1\u989d", (Object[])new Object[0]);
                } else if (MeetConditionsEnum.GIFT_MQSQ.getCode().equals(promotionPolicy.getMeetConditions()) || MeetConditionsEnum.GIFT_MMSQ.getCode().equals(promotionPolicy.getMeetConditions())) {
                    List afterGifts = ladderList.get(i + 1).getPromotionPolicyGiftList();
                    List productCodeList = afterGifts.stream().map(PromotionPolicyGiftDto::getProductCode).filter(Objects::nonNull).collect(Collectors.toList());
                    if (BooleanEnum.TRUE.getCapital().equals(promotionPolicy.getYesOrNo())) {
                        BigDecimal front22 = ladderList.get(i).getGivePriceOrQuantity();
                        BigDecimal after22 = ladderList.get(i + 1).getGivePriceOrQuantity();
                        Validate.isTrue((after22.compareTo(front22) > 0 ? 1 : 0) != 0, (String)"\u540e\u9636\u68af\u7684\u8d60\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u524d\u9636\u68af\u7684\u8d60\u54c1\u6570\u91cf", (Object[])new Object[0]);
                        Validate.isTrue((ladder.getPromotionPolicyGiftList().size() == productCodeList.size() ? 1 : 0) != 0, (String)"\u9636\u68af\u95f4\u8d60\u54c1\u9700\u76f8\u540c\uff01", (Object[])new Object[0]);
                        ladder.getPromotionPolicyGiftList().forEach(gift -> Validate.isTrue((boolean)productCodeList.contains(gift.getProductCode()), (String)"\u9636\u68af\u95f4\u8d60\u54c1\u9700\u76f8\u540c\uff01", (Object[])new Object[0]));
                    } else {
                        Validate.isTrue((ladder.getPromotionPolicyGiftList().size() == 1 ? 1 : 0) != 0, (String)"\u9009\u62e9'\u8d60\u54c1\u4e0d\u76f8\u540c'\uff0c\u5355\u4e2a\u9636\u68af\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u8d60\u54c1\uff01", (Object[])new Object[0]);
                        ladder.getPromotionPolicyGiftList().forEach(gift -> Validate.isTrue((!productCodeList.contains(gift.getProductCode()) ? 1 : 0) != 0, (String)"\u9009\u62e9'\u8d60\u54c1\u4e0d\u76f8\u540c'\uff0c\u9636\u68af\u95f4\u8d60\u54c1\u4e0d\u80fd\u76f8\u540c\uff01", (Object[])new Object[0]));
                    }
                }
            }
            PromotionPolicyLadderVO ladderVo = (PromotionPolicyLadderVO)this.nebulaToolkitService.copyObjectByWhiteList((Object)ladder, PromotionPolicyLadderVO.class, HashSet.class, ArrayList.class, new String[0]);
            if (MeetConditionsEnum.GIFT_MQSQ.getCode().equals(promotionPolicy.getMeetConditions()) || MeetConditionsEnum.GIFT_MMSQ.getCode().equals(promotionPolicy.getMeetConditions())) {
                ladder.getPromotionPolicyGiftList().forEach(gift -> {
                    Validate.notBlank((CharSequence)gift.getProductCode(), (String)"\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)gift.getProductCode(), (String)"\u8d60\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    if (StringUtils.isBlank((CharSequence)gift.getId())) {
                        String uuid = UUID.randomUUID().toString().replace("-", "");
                        gift.setId(uuid);
                    }
                    gift.setPromotionCode(promotionPolicy.getPromotionCode());
                    gift.setLadderCode(ladder.getLadderCode());
                    gift.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    gift.setTenantCode(ladder.getTenantCode());
                });
                this.promotionPolicyGiftService.saveOrUpdate(ladder.getPromotionPolicyGiftList());
                List giftVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)ladder.getPromotionPolicyGiftList(), PromotionPolicyGiftDto.class, PromotionPolicyGiftVO.class, HashSet.class, ArrayList.class, new String[0]);
                ladderVo.setPromotionPolicyGiftList(giftVoList);
            }
            ladderVoList.add(ladderVo);
        }
        return ladderVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.notNull(ids, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List dbPromotionPolicyList = this.promotionPolicyRepository.listByIds(ids);
        Validate.notEmpty((Collection)dbPromotionPolicyList, (String)"\u6839\u636e\u63d0\u4f9b\u7684\u4fe1\u606f\uff0c\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u653f\u7b56", (Object[])new Object[0]);
        List<String> codes = dbPromotionPolicyList.stream().map(PromotionPolicy::getPromotionCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        PromotionPolicyToSubActDesignEventDto eventDto = new PromotionPolicyToSubActDesignEventDto();
        eventDto.setPromotionCodes(codes);
        SerializableBiConsumer & Serializable hasRelationPolicy = PromotionPolicyToSubActDesignListener::hasRelationPolicy;
        RelationPolicySelectDto response = (RelationPolicySelectDto)this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, PromotionPolicyToSubActDesignListener.class, (SerializableBiConsumer)hasRelationPolicy);
        if (Objects.nonNull(response) && !org.springframework.util.CollectionUtils.isEmpty((Map)response.getResp())) {
            Map respMap = response.getResp();
            codes.forEach(code -> {
                if (respMap.containsKey(code)) {
                    Boolean isRelation = (Boolean)respMap.get(code);
                    Validate.isTrue((isRelation == false ? 1 : 0) != 0, (String)("\u5df2\u6709\u6d3b\u52a8\u89c4\u5212\u5173\u8054\u4e86\u653f\u7b56" + code + "\uff0c\u4e0d\u53ef\u5220\u9664"), (Object[])new Object[0]);
                }
            });
        }
        List<String> promotionCodes = dbPromotionPolicyList.stream().map(PromotionPolicy::getPromotionCode).filter(Objects::nonNull).collect(Collectors.toList());
        this.promotionPolicyGiftService.deleteByPromotionCode(promotionCodes);
        this.promotionPolicyLadderService.deleteByPromotionCode(promotionCodes);
        this.promotionPolicyProductService.deleteByPromotionCode(promotionCodes);
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"del_flag", (Object)DelFlagStatusEnum.DELETE.getCode());
        wrapper.set((Object)"enable_status", (Object)EnableStatusEnum.DISABLE.getCode());
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.in((Object)"promotion_code", promotionCodes);
        dbPromotionPolicyList.forEach(promotionPolicy -> {
            PromotionPolicyLogEventDto logEventDto = new PromotionPolicyLogEventDto();
            PromotionPolicyVO oldVo = (PromotionPolicyVO)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPolicy, PromotionPolicyVO.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            PromotionPolicyDto promotionPolicyDto = (PromotionPolicyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPolicy, PromotionPolicyDto.class, null, null, new String[0]);
            promotionPolicyDto.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            promotionPolicyDto.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            logEventDto.setNewest(promotionPolicyDto);
            SerializableBiConsumer & Serializable onDelete = PromotionPolicyLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PromotionPolicyLogEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.promotionPolicyRepository.update((Wrapper)wrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateEnableStatus(List<String> ids, String enableStatus) {
        Validate.notNull(ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)EnableStatusEnum.contains((String)enableStatus), (String)"\u672a\u77e5\u7684\u542f\u7981\u7528\u72b6\u6001", (Object[])new Object[0]);
        List dbPromotionPolicyList = this.promotionPolicyRepository.listByIds(ids);
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"enable_status", (Object)enableStatus);
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.in((Object)"id", ids);
        dbPromotionPolicyList.forEach(promotionPolicy -> {
            PromotionPolicyLogEventDto logEventDto = new PromotionPolicyLogEventDto();
            PromotionPolicyVO oldVo = (PromotionPolicyVO)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPolicy, PromotionPolicyVO.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            PromotionPolicyDto promotionPolicyDto = (PromotionPolicyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPolicy, PromotionPolicyDto.class, null, null, new String[0]);
            promotionPolicyDto.setEnableStatus(enableStatus);
            logEventDto.setNewest(promotionPolicyDto);
            if (EnableStatusEnum.ENABLE.getCode().equals(enableStatus)) {
                SerializableBiConsumer & Serializable onEnable = PromotionPolicyLogEventListener::onEnable;
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PromotionPolicyLogEventListener.class, (SerializableBiConsumer)onEnable);
            } else {
                SerializableBiConsumer & Serializable onDisable = PromotionPolicyLogEventListener::onDisable;
                this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PromotionPolicyLogEventListener.class, (SerializableBiConsumer)onDisable);
            }
        });
        this.promotionPolicyRepository.update((Wrapper)wrapper);
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(PromotionPolicyDto promotionPolicy) {
        this.createOrUpdateValidate(promotionPolicy);
        PromotionPolicyVO dbPromotionPolicy = this.findByIdOrPromotionCode(promotionPolicy.getId(), null);
        Validate.notNull((Object)dbPromotionPolicy, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u653f\u7b56\uff01", (Object[])new Object[0]);
        PromotionPolicyToSubActDesignEventDto eventDto = new PromotionPolicyToSubActDesignEventDto();
        ArrayList<String> eventCodes = new ArrayList<String>();
        eventCodes.add(promotionPolicy.getPromotionCode());
        eventDto.setPromotionCodes(eventCodes);
        SerializableBiConsumer & Serializable hasRelationPolicy = PromotionPolicyToSubActDesignListener::hasRelationPolicy;
        EventResponse eventResponse = this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, PromotionPolicyToSubActDesignListener.class, (SerializableBiConsumer)hasRelationPolicy);
        Validate.notNull((Object)eventResponse, (String)"\u8c03\u7528\u6d3b\u52a8\u89c4\u5212\u4e8b\u4ef6\uff0c\u67e5\u8be2\u662f\u5426\u5173\u8054\u653f\u7b56\uff0c\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RelationPolicySelectDto respDto = (RelationPolicySelectDto)eventResponse;
        Map respMap = respDto.getResp();
        if (!org.springframework.util.CollectionUtils.isEmpty((Map)respMap) && respMap.containsKey(promotionPolicy.getPromotionCode())) {
            Boolean isRelation = (Boolean)respMap.get(promotionPolicy.getPromotionCode());
            Validate.isTrue((isRelation == false ? 1 : 0) != 0, (String)"\u5df2\u6709\u6d3b\u52a8\u89c4\u5212\u5173\u8054\u4e86\u653f\u7b56\uff0c\u4e0d\u53ef\u518d\u4fee\u6539", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)promotionPolicy.getTenantCode())) {
            promotionPolicy.setTenantCode(TenantUtils.getTenantCode());
        }
        Validate.isTrue((boolean)dbPromotionPolicy.getTenantCode().equals(promotionPolicy.getTenantCode()), (String)"\u79df\u6237\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)dbPromotionPolicy.getPromotionCode().equals(promotionPolicy.getPromotionCode()), (String)"\u4fc3\u9500\u7f16\u7801\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)dbPromotionPolicy.getPromotionTypeCode().equals(promotionPolicy.getPromotionTypeCode()), (String)"\u4fc3\u9500\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)dbPromotionPolicy.getPromotionProductType().equals(promotionPolicy.getPromotionProductType()), (String)"\u4fc3\u9500\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
        if (PromotionTypeEnum.GIFT.getCode().equals(dbPromotionPolicy.getPromotionTypeCode())) {
            Validate.isTrue((boolean)dbPromotionPolicy.getYesOrNo().equals(promotionPolicy.getYesOrNo()), (String)"'\u8d60\u54c1\u662f\u5426\u76f8\u540c'\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
        }
        PromotionPolicyLogEventDto logEventDto = new PromotionPolicyLogEventDto();
        logEventDto.setOriginal(dbPromotionPolicy);
        logEventDto.setNewest(promotionPolicy);
        SerializableBiConsumer & Serializable onUpdate = PromotionPolicyLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, PromotionPolicyLogEventListener.class, (SerializableBiConsumer)onUpdate);
        PromotionPolicy entity = (PromotionPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPolicy, PromotionPolicy.class, HashSet.class, ArrayList.class, new String[0]));
        this.promotionPolicyRepository.updateById((Object)entity);
    }

    @Transactional(rollbackFor={Exception.class})
    public Collection<PromotionPolicyProductVO> addProducts(String promotionCode, List<PromotionPolicyProductDto> productList) {
        Validate.notBlank((CharSequence)promotionCode, (String)"\u4fc3\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
        PromotionPolicy one = (PromotionPolicy)((Object)this.promotionPolicyRepository.getOne((Wrapper)wrapper));
        if (one != null) {
            List<PromotionPolicyProductVO> dbProducts = this.promotionPolicyProductService.findByPromotionCode(one.getPromotionCode());
            Map<String, PromotionPolicyProductVO> dbProductMap = dbProducts.stream().collect(Collectors.toMap(UuidVo::getId, productVO -> productVO));
            productList.forEach(product -> {
                Validate.notBlank((CharSequence)product.getProductCode(), (String)"\u672c\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)product.getProductName(), (String)"\u672c\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                if (!StringUtils.isBlank((CharSequence)product.getId())) {
                    PromotionPolicyProductVO dbproduct = (PromotionPolicyProductVO)dbProductMap.get(product.getId());
                    Validate.notNull((Object)dbproduct, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u672c\u54c1\uff01", (Object[])new Object[0]);
                    Validate.isTrue((boolean)dbproduct.getProductCode().equals(product.getProductCode()), (String)"\u672c\u54c1\u7f16\u7801\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
                    Validate.isTrue((boolean)dbproduct.getProductName().equals(product.getProductName()), (String)"\u672c\u54c1\u540d\u79f0\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
                } else {
                    String uuid = UUID.randomUUID().toString().replace("-", "");
                    product.setId(uuid);
                }
                product.setPromotionCode(one.getPromotionCode());
                product.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                product.setTenantCode(one.getTenantCode());
            });
            this.promotionPolicyProductService.saveOrUpdate(productList);
        } else {
            Validate.isTrue((boolean)false, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u653f\u7b56", (Object[])new Object[0]);
        }
        return this.nebulaToolkitService.copyCollectionByWhiteList(productList, PromotionPolicyProductDto.class, PromotionPolicyProductVO.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public Collection<PromotionPolicyLadderVO> addLadder(String promotionCode, List<PromotionPolicyLadderDto> ladderList) {
        Validate.notBlank((CharSequence)promotionCode, (String)"\u4fc3\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
        PromotionPolicy one = (PromotionPolicy)((Object)this.promotionPolicyRepository.getOne((Wrapper)wrapper));
        Validate.notNull((Object)((Object)one), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u653f\u7b56", (Object[])new Object[0]);
        List<PromotionPolicyLadderVO> dbladderVOList = this.promotionPolicyLadderService.findByPromotionCode(one.getPromotionCode());
        Set dbLadderCodeSet = dbladderVOList.stream().map(PromotionPolicyLadderVO::getLadderCode).filter(Objects::nonNull).collect(Collectors.toSet());
        this.priceOrQuantityValidate(ladderList);
        ladderList.forEach(ladder -> {
            if (!StringUtils.isBlank((CharSequence)ladder.getLadderCode())) {
                Validate.isTrue((boolean)dbLadderCodeSet.contains(ladder.getLadderCode()), (String)"\u9636\u68af\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01", (Object[])new Object[0]);
            } else {
                String uuid = UUID.randomUUID().toString().replace("-", "");
                ladder.setId(uuid);
            }
        });
        PromotionPolicyDto oneDto = (PromotionPolicyDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)one, PromotionPolicyDto.class, HashSet.class, ArrayList.class, new String[0]);
        List ladderVoList = (List)this.buildLadder(oneDto, ladderList);
        this.promotionPolicyLadderService.saveOrUpdate(ladderVoList);
        return ladderVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteLadder(String promotionCode, String ladderCode) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)promotionCode) && !StringUtils.isBlank((CharSequence)ladderCode) ? 1 : 0) != 0, (String)"\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u6216\u9636\u68af\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        PromotionPolicy one = (PromotionPolicy)((Object)this.promotionPolicyRepository.getOne((Wrapper)wrapper));
        Validate.notNull((Object)((Object)one), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u4fc3\u9500\u653f\u7b56", (Object[])new Object[0]);
        this.promotionPolicyLadderService.deleteLadder(one, ladderCode);
    }

    public void deleteGift(String promotionCode, String productCode) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)promotionCode) && !StringUtils.isBlank((CharSequence)productCode) ? 1 : 0) != 0, (String)"\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u6216\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"promotion_code", (Object)promotionCode);
        PromotionPolicy one = (PromotionPolicy)((Object)this.promotionPolicyRepository.getOne((Wrapper)wrapper));
        Validate.notNull((Object)((Object)one), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u653f\u7b56", (Object[])new Object[0]);
        this.promotionPolicyGiftService.deleteGiftByProductCode(one.getPromotionCode(), productCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public void createEcommerce(PromotionPolicyDto promotionPolicy) {
        this.createOrUpdateEcommerceValidate(promotionPolicy);
        promotionPolicy.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        promotionPolicy.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        promotionPolicy.setTenantCode(TenantUtils.getTenantCode());
        String promotionCode = (String)this.generateCodeService.generateCode("CX", 1, Integer.valueOf(3), 2L, TimeUnit.DAYS).get(0);
        Validate.notBlank((CharSequence)promotionCode, (String)"\u4fc3\u9500\u7f16\u53f7\u751f\u6210\u5931\u8d25", (Object[])new Object[0]);
        promotionPolicy.setPromotionCode(promotionCode);
        PromotionPolicy entity = (PromotionPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPolicy, PromotionPolicy.class, HashSet.class, ArrayList.class, new String[0]));
        this.promotionPolicyRepository.save((Object)entity);
        promotionPolicy.getPromotionPolicyProducts().forEach(productDto -> {
            Validate.notBlank((CharSequence)productDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u591f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)productDto.getProductName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u591f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)productDto.getBindingCoefficient(), (String)"\u6346\u8d60\u7cfb\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            productDto.setPromotionCode(promotionCode);
            productDto.setDelFlag(promotionPolicy.getDelFlag());
            productDto.setTenantCode(promotionPolicy.getTenantCode());
        });
        this.promotionPolicyProductService.create(promotionPolicy.getPromotionPolicyProducts());
    }

    public void updateEcommerce(PromotionPolicyDto promotionPolicy) {
        this.createOrUpdateEcommerceValidate(promotionPolicy);
        PromotionPolicy dbPromotionPolicy = (PromotionPolicy)((Object)this.promotionPolicyRepository.getById((Serializable)((Object)promotionPolicy.getId())));
        Validate.notNull((Object)((Object)dbPromotionPolicy), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4fc3\u9500\u653f\u7b56", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)promotionPolicy.getTenantCode())) {
            promotionPolicy.setTenantCode(TenantUtils.getTenantCode());
        }
        Validate.isTrue((boolean)dbPromotionPolicy.getTenantCode().equals(promotionPolicy.getTenantCode()), (String)"\u79df\u6237\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        Validate.isTrue((boolean)dbPromotionPolicy.getPromotionCode().equals(promotionPolicy.getPromotionCode()), (String)"\u4fc3\u9500\u7f16\u7801\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)dbPromotionPolicy.getPromotionTypeCode().equals(promotionPolicy.getPromotionTypeCode()), (String)"\u4fc3\u9500\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539\uff01", (Object[])new Object[0]);
        PromotionPolicy entity = (PromotionPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)promotionPolicy, PromotionPolicy.class, HashSet.class, ArrayList.class, new String[0]));
        this.promotionPolicyRepository.updateById((Object)entity);
    }

    public List<PromotionPolicyVO> findByPromotionCodes(List<String> promotionCodeList) {
        if (CollectionUtils.isNotEmpty(promotionCodeList)) {
            ArrayList<PromotionPolicyVO> list = new ArrayList<PromotionPolicyVO>();
            promotionCodeList.forEach(code -> {
                PromotionPolicyVO promotionPolicy = this.findByIdOrPromotionCode(null, (String)code);
                list.add(promotionPolicy);
            });
            return list;
        }
        return null;
    }

    public List<PromotionPolicyProductVO> findForDistributionCustomerMonthSale(List<String> productCodeList, String lastMonth) {
        String promotionType = PromotionTypeEnum.GIFT_BINDING.getCode();
        List<PromotionPolicyProductVO> policyProductList = this.promotionPolicyRepository.findForDistributionCustomerMonthSale(promotionType, productCodeList, lastMonth);
        return policyProductList;
    }

    public List<PromotionPolicyVO> findListByYearMonth(String yearMonth) {
        String monthFirstDay = yearMonth + "-01";
        List<PromotionPolicyVO> promotionPolicyVOList = this.promotionPolicyRepository.findListByYearMonth(monthFirstDay);
        for (PromotionPolicyVO policyVO : promotionPolicyVOList) {
            policyVO.setPromotionPolicyProducts(this.promotionPolicyProductService.findByPromotionCode(policyVO.getPromotionCode()));
        }
        return promotionPolicyVOList;
    }

    private void createOrUpdateEcommerceValidate(PromotionPolicyDto promotionPolicy) {
        Validate.notNull((Object)promotionPolicy, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)promotionPolicy.getPromotionName(), (String)"\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)PromotionTypeEnum.GIFT_BINDING.getCode().equals(promotionPolicy.getPromotionTypeCode()), (String)"\u4fc3\u9500\u7c7b\u578b\u4e0d\u5bf9\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)promotionPolicy.getBindBeginDate(), (String)"\u7f3a\u5c11\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4!", (Object[])new Object[0]);
        Validate.notNull((Object)promotionPolicy.getBindEndDate(), (String)"\u7f3a\u5c11\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)promotionPolicy.getCumulative(), (String)"'\u662f\u5426\u7d2f\u8ba1',\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((BooleanEnum.TRUE.getCapital().equals(promotionPolicy.getCumulative()) || BooleanEnum.FALSE.getCapital().equals(promotionPolicy.getCumulative()) ? 1 : 0) != 0, (String)"\u672a\u77e5\u7684\u7b26\u53f7 :'\u662f\u5426\u7d2f\u8ba1'", (Object[])new Object[0]);
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar1.setTime(promotionPolicy.getBindBeginDate());
        calendar2.setTime(promotionPolicy.getBindEndDate());
        Validate.isTrue((calendar1.getTimeInMillis() <= calendar2.getTimeInMillis() ? 1 : 0) != 0, (String)"\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01", (Object[])new Object[0]);
        int year1 = calendar1.get(1);
        int year2 = calendar2.get(1);
        int month1 = calendar1.get(2);
        int month2 = calendar2.get(2);
        if (year1 == year2 && month1 == month2) {
            Validate.isTrue((boolean)BooleanEnum.FALSE.getCapital().equals(promotionPolicy.getCumulative()), (String)"\u540c\u6708\u65f6,'\u662f\u5426\u7d2f\u8ba1'\u53ea\u80fd\u4e3a'\u5426'", (Object[])new Object[0]);
        }
        Validate.isTrue((promotionPolicy.getPromotionPolicyProducts() != null && promotionPolicy.getPromotionPolicyProducts().size() > 0 ? 1 : 0) != 0, (String)"\u9700\u81f3\u5c11\u6dfb\u52a0\u4e00\u4ef6\u4ea7\u54c1\uff01", (Object[])new Object[0]);
    }

    void sameDateSameProductValidate(PromotionPolicyDto promotionPolicy, List<PromotionPolicyProductDto> products) {
        List<PromotionPolicyProduct> productList;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq((Object)"tenant_code", (Object)TenantUtils.getTenantCode());
        wrapper.eq((Object)"promotion_type_code", (Object)PromotionTypeEnum.GIFT_BINDING.getCode());
        if (!StringUtils.isBlank((CharSequence)promotionPolicy.getPromotionCode())) {
            wrapper.ne((Object)"promotion_code", (Object)promotionPolicy.getPromotionCode());
        }
        wrapper.le((Object)"bind_begin_date", (Object)promotionPolicy.getBindEndDate());
        wrapper.ge((Object)"bind_end_date", (Object)promotionPolicy.getBindBeginDate());
        List promotionPolicies = this.promotionPolicyRepository.list((Wrapper)wrapper);
        Set<String> promotionCodes = promotionPolicies.stream().map(PromotionPolicy::getPromotionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (promotionPolicies != null && promotionPolicies.size() > 0 && (productList = this.promotionPolicyProductService.findProductInSameDate(promotionCodes)) != null) {
            Set dbProductCodes = productList.stream().map(PromotionPolicyProduct::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
            products.forEach(product -> Validate.isTrue((!dbProductCodes.contains(product.getProductCode()) ? 1 : 0) != 0, (String)("\u4ea7\u54c1\uff1a[ \u7f16\u7801: " + product.getProductCode() + " ,\u540d\u79f0: " + product.getProductName() + " ] \u5728\u540c\u65f6\u95f4\u5185\u5df2\u7ed1\u5b9a\u4e86\u653f\u7b56"), (Object[])new Object[0]));
        }
    }

    private void priceOrQuantityValidate(List<PromotionPolicyLadderDto> ladderList) {
        ladderList.forEach(ladder -> {
            Validate.notNull((Object)ladder.getMeetPriceOrQuantity(), (String)"\u91d1\u989d\u6216\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((ladder.getMeetPriceOrQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u6216\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)ladder.getGivePriceOrQuantity(), (String)"\u91d1\u989d\u6216\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.isTrue((ladder.getGivePriceOrQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u6216\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        });
    }

    private void createOrUpdateValidate(PromotionPolicyDto promotionPolicy) {
        Validate.notNull((Object)promotionPolicy, (String)"\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!PromotionTypeEnum.GIFT_BINDING.getCode().equals(promotionPolicy.getPromotionTypeCode())) {
            Validate.notBlank((CharSequence)promotionPolicy.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)promotionPolicy.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)promotionPolicy.getPromotionProductType(), (String)"\u4fc3\u9500\u5546\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)PromotionProductTypeEnum.contains((String)promotionPolicy.getPromotionProductType()), (String)"\u672a\u77e5\u7684\u4fc3\u9500\u5546\u54c1\u7c7b\u578b\uff01", (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)promotionPolicy.getPriorityLevel(), (String)"\u4f18\u5148\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)promotionPolicy.getPromotionName(), (String)"\u4fc3\u9500\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)promotionPolicy.getPromotionTypeCode(), (String)"\u4fc3\u9500\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)PromotionTypeEnum.contains((String)promotionPolicy.getPromotionTypeCode()), (String)"\u672a\u77e5\u7684\u4fc3\u9500\u7c7b\u578b\uff01", (Object[])new Object[0]);
        Validate.isTrue((promotionPolicy.getPromotionPolicyProducts() != null && promotionPolicy.getPromotionPolicyProducts().size() > 0 ? 1 : 0) != 0, (String)"\u9700\u81f3\u5c11\u6dfb\u52a0\u4e00\u4ef6\u672c\u54c1\uff01", (Object[])new Object[0]);
        if (PromotionTypeEnum.SPECIAL_PRICE.getCode().equals(promotionPolicy.getPromotionTypeCode()) && PromotionProductTypeEnum.GROUP_SPECIAL_PRICE.getCode().equals(promotionPolicy.getPromotionProductType())) {
            Validate.notNull((Object)promotionPolicy.getOriginalPrice(), (String)"\u7279\u4ef7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((promotionPolicy.getOriginalPrice().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u7279\u4ef7\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        } else if (!PromotionTypeEnum.GIFT_BINDING.getCode().equals(promotionPolicy.getPromotionTypeCode())) {
            Validate.notNull((Object)promotionPolicy.getMeetConditions(), (String)"\u6ee1\u8db3\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)promotionPolicy.getCalculationRules(), (String)"\u8ba1\u7b97\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)MeetConditionsEnum.contains((String)promotionPolicy.getMeetConditions()), (String)"\u672a\u77e5\u7684\u6ee1\u8db3\u6761\u4ef6\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)CalculationRulesEnum.contains((String)promotionPolicy.getCalculationRules()), (String)"\u672a\u77e5\u7684\u8ba1\u7b97\u89c4\u5219\uff01", (Object[])new Object[0]);
            Validate.isTrue((promotionPolicy.getPromotionPolicyLadders() != null && promotionPolicy.getPromotionPolicyLadders().size() > 0 ? 1 : 0) != 0, (String)"\u9700\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u9636\u68af\uff01", (Object[])new Object[0]);
            if (PromotionTypeEnum.GIFT.getCode().equals(promotionPolicy.getPromotionTypeCode())) {
                Validate.notBlank((CharSequence)promotionPolicy.getYesOrNo(), (String)"\u8bf7\u9009\u62e9'\u8d60\u54c1\u662f\u5426\u76f8\u540c'", (Object[])new Object[0]);
                Validate.isTrue((BooleanEnum.TRUE.getCapital().equals(promotionPolicy.getYesOrNo()) || BooleanEnum.FALSE.getCapital().equals(promotionPolicy.getYesOrNo()) ? 1 : 0) != 0, (String)"\u672a\u77e5\u7684\u7b26\u53f7 :'\u8d60\u54c1\u662f\u5426\u76f8\u540c'", (Object[])new Object[0]);
                List ladderList = promotionPolicy.getPromotionPolicyLadders();
                for (int i = 0; i < ladderList.size(); ++i) {
                    Validate.notBlank((CharSequence)((PromotionPolicyLadderDto)ladderList.get(i)).getUnit(), (String)"\u8d60\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                    List giftList = ((PromotionPolicyLadderDto)ladderList.get(i)).getPromotionPolicyGiftList();
                    List giftCodeList = giftList.stream().map(PromotionPolicyGiftDto::getProductCode).filter(Objects::nonNull).collect(Collectors.toList());
                    Validate.isTrue((giftList != null && giftList.size() > 0 ? 1 : 0) != 0, (String)"\u6bcf\u4e2a\u9636\u68af\u4e2d\u81f3\u5c11\u9700\u6709\u4e00\u4e2a\u8d60\u54c1", (Object[])new Object[0]);
                    if (ladderList.size() > 1 && i < ladderList.size() - 1) {
                        int n;
                        List fontGiftList = ((PromotionPolicyLadderDto)ladderList.get(i + 1)).getPromotionPolicyGiftList();
                        Validate.notNull((Object)fontGiftList, (String)"\u6bcf\u4e2a\u9636\u68af\u4e2d\u81f3\u5c11\u9700\u6709\u4e00\u4e2a\u8d60\u54c1", (Object[])new Object[0]);
                        if (BooleanEnum.TRUE.getCapital().equals(promotionPolicy.getYesOrNo())) {
                            Validate.isTrue((giftList.size() == fontGiftList.size() ? 1 : 0) != 0, (String)"\u9636\u68af\u95f4\u8d60\u54c1\u9700\u76f8\u540c\uff01", (Object[])new Object[0]);
                            for (n = 0; n < giftList.size(); ++n) {
                                Validate.notBlank((CharSequence)((PromotionPolicyGiftDto)giftList.get(n)).getProductCode(), (String)"\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                                Validate.isTrue((boolean)giftCodeList.contains(((PromotionPolicyGiftDto)fontGiftList.get(n)).getProductCode()), (String)"\u9636\u68af\u95f4\u8d60\u54c1\u9700\u76f8\u540c\uff01", (Object[])new Object[0]);
                            }
                            continue;
                        }
                        for (n = 0; n < giftList.size(); ++n) {
                            Validate.isTrue((!giftCodeList.contains(((PromotionPolicyGiftDto)fontGiftList.get(n)).getProductCode()) ? 1 : 0) != 0, (String)"\u9636\u68af\u95f4\u8d60\u54c1\u4e0d\u80fd\u76f8\u540c\uff01", (Object[])new Object[0]);
                        }
                        continue;
                    }
                    if (!BooleanEnum.FALSE.getCapital().equals(promotionPolicy.getYesOrNo())) continue;
                    Validate.isTrue((giftList.size() == 1 ? 1 : 0) != 0, (String)"\u9009\u62e9'\u8d60\u54c1\u4e3a\u4e0d\u76f8\u540c'\uff0c\u5355\u4e2a\u9636\u68af\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u8d60\u54c1", (Object[])new Object[0]);
                    Validate.notBlank((CharSequence)((PromotionPolicyGiftDto)giftList.get(0)).getProductCode(), (String)"\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                }
            }
        }
    }

    public List<PromotionPolicyVO> findPolicyByPromotionCodes(List<String> promotionCodes) {
        if (CollectionUtils.isEmpty(promotionCodes)) {
            return Lists.newArrayList();
        }
        List<PromotionPolicy> list = this.promotionPolicyRepository.findPolicyByPromotionCodes(promotionCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, PromotionPolicy.class, PromotionPolicyVO.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public Map<String, Boolean> hasRelationPolicyConfig(List<String> configCodes) {
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(configCodes)) {
            return resultMap;
        }
        List<PromotionPolicy> list = this.promotionPolicyRepository.hasRelationPolicyConfig(configCodes);
        if (CollectionUtils.isEmpty(list)) {
            return resultMap;
        }
        Map<String, List<PromotionPolicy>> policyMap = list.stream().collect(Collectors.groupingBy(PromotionPolicy::getTemplateCode));
        for (String key : policyMap.keySet()) {
            List<PromotionPolicy> promotionPolicies = policyMap.get(key);
            if (CollectionUtils.isEmpty(promotionPolicies)) {
                resultMap.put(key, true);
                continue;
            }
            resultMap.put(key, false);
        }
        return resultMap;
    }
}

