/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.policy.template.config.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.promotion.policy.template.config.local.entity.TpmPromotionPolicyTemplateConfigDetailEntity;
import com.biz.crm.tpm.business.promotion.policy.template.config.local.entity.TpmPromotionPolicyTemplateConfigEntity;
import com.biz.crm.tpm.business.promotion.policy.template.config.local.mapper.TpmPromotionPolicyTemplateConfigDetailEntityMapper;
import com.biz.crm.tpm.business.promotion.policy.template.config.local.mapper.TpmPromotionPolicyTemplateConfigEntityMapper;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.dto.SelectRelationPolicyEventDto;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.dto.SelectRelationPolicyEventResponse;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.dto.TpmPromotionPolicyTemplateConfigDetailDto;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.dto.TpmPromotionPolicyTemplateConfigDto;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.dto.TpmPromotionPolicyTemplateConfigLogDto;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.event.TpmPromotionPolicyTemplateConfigLogEventListener;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.service.TpmPromotionPolicyTemplateConfigEventListener;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.service.TpmPromotionPolicyTemplateConfigService;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.vo.TpmPromotionPolicyTemplateConfigDetailRespVo;
import com.biz.crm.tpm.business.promotion.policy.template.config.sdk.vo.TpmPromotionPolicyTemplateConfigRespVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TpmPromotionPolicyTemplateConfigServiceImpl
implements TpmPromotionPolicyTemplateConfigService {
    private static final Logger log = LoggerFactory.getLogger(TpmPromotionPolicyTemplateConfigServiceImpl.class);
    @Autowired(required=false)
    private TpmPromotionPolicyTemplateConfigEntityMapper tpmPromotionPolicyTemplateConfigEntityMapper;
    @Autowired(required=false)
    private TpmPromotionPolicyTemplateConfigDetailEntityMapper tpmPromotionPolicyTemplateConfigDetailEntityMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private TpmPromotionPolicyTemplateConfigLogEventListener tpmPromotionPolicyTemplateConfigLogEventListener;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<TpmPromotionPolicyTemplateConfigRespVo> findByConditions(Pageable pageable, TpmPromotionPolicyTemplateConfigDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new TpmPromotionPolicyTemplateConfigDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmPromotionPolicyTemplateConfigEntityMapper.findByConditions((Page<TpmPromotionPolicyTemplateConfigRespVo>)page, dto);
    }

    public TpmPromotionPolicyTemplateConfigRespVo findById(String id) {
        TpmPromotionPolicyTemplateConfigRespVo respVo = this.tpmPromotionPolicyTemplateConfigEntityMapper.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (DelFlagStatusEnum.DELETE.getCode().equals(respVo.getDelFlag())) {
            throw new UnsupportedOperationException("");
        }
        List<TpmPromotionPolicyTemplateConfigDetailEntity> detailEntityList = this.tpmPromotionPolicyTemplateConfigDetailEntityMapper.findByPromotionConfigCode(respVo.getPromotionPolicyTemplateCode());
        ArrayList<Object> detailRespVoList = new ArrayList<Object>();
        for (TpmPromotionPolicyTemplateConfigDetailEntity detailEntity : detailEntityList) {
            detailRespVoList.add(this.nebulaToolkitService.copyObjectByWhiteList((Object)detailEntity, TpmPromotionPolicyTemplateConfigDetailRespVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        }
        respVo.setDetails(detailRespVoList);
        return respVo;
    }

    public TpmPromotionPolicyTemplateConfigRespVo findByCode(String code) {
        TpmPromotionPolicyTemplateConfigRespVo respVo = this.tpmPromotionPolicyTemplateConfigEntityMapper.findByCodeAndTenantCode(code, TenantUtils.getTenantCode());
        if (DelFlagStatusEnum.DELETE.getCode().equals(respVo.getDelFlag())) {
            throw new UnsupportedOperationException("\u8be5\u4fc3\u9500\u6a21\u677f\u89c4\u5219\u5df2\u5220\u9664");
        }
        List<TpmPromotionPolicyTemplateConfigDetailEntity> detailEntityList = this.tpmPromotionPolicyTemplateConfigDetailEntityMapper.findByPromotionConfigCode(respVo.getPromotionPolicyTemplateCode());
        ArrayList<Object> detailRespVoList = new ArrayList<Object>();
        for (TpmPromotionPolicyTemplateConfigDetailEntity detailEntity : detailEntityList) {
            detailRespVoList.add(this.nebulaToolkitService.copyObjectByWhiteList((Object)detailEntity, TpmPromotionPolicyTemplateConfigDetailRespVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        }
        respVo.setDetails(detailRespVoList);
        return respVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmPromotionPolicyTemplateConfigRespVo create(TpmPromotionPolicyTemplateConfigDto dto) {
        if (dto.validate()) {
            if (!CollectionUtils.isEmpty((Collection)dto.getDetails())) {
                for (TpmPromotionPolicyTemplateConfigDetailDto detailDto : dto.getDetails()) {
                    if (detailDto.validate()) continue;
                    throw new UnsupportedOperationException("\u6570\u636e\u4e0d\u5b8c\u6574");
                }
            } else {
                throw new UnsupportedOperationException("\u7f3a\u5c11\u4fc3\u9500\u653f\u7b56\u89c4\u5219");
            }
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        TpmPromotionPolicyTemplateConfigEntity entity = (TpmPromotionPolicyTemplateConfigEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, TpmPromotionPolicyTemplateConfigEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        String ruleCode = "CXMB";
        entity.setPromotionPolicyTemplateCode((String)this.generateCodeService.generateCode(ruleCode, 1).get(0));
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.tpmPromotionPolicyTemplateConfigEntityMapper.insert((Object)entity);
        for (TpmPromotionPolicyTemplateConfigDetailDto detailDto : dto.getDetails()) {
            TpmPromotionPolicyTemplateConfigDetailEntity detailEntity = (TpmPromotionPolicyTemplateConfigDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailDto, TpmPromotionPolicyTemplateConfigDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            detailEntity.setPromotionPolicyTemplateCode(entity.getPromotionPolicyTemplateCode());
            detailEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            detailEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detailEntity.setTenantCode(TenantUtils.getTenantCode());
            this.tpmPromotionPolicyTemplateConfigDetailEntityMapper.insert((Object)detailEntity);
        }
        TpmPromotionPolicyTemplateConfigLogDto logDto = new TpmPromotionPolicyTemplateConfigLogDto();
        logDto.setNewest(dto);
        this.tpmPromotionPolicyTemplateConfigLogEventListener.onCreate(logDto);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmPromotionPolicyTemplateConfigRespVo update(TpmPromotionPolicyTemplateConfigDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getId()) && dto.validate()) {
            if (!CollectionUtils.isEmpty((Collection)dto.getDetails())) {
                for (TpmPromotionPolicyTemplateConfigDetailDto detailDto : dto.getDetails()) {
                    if (detailDto.validate()) continue;
                    throw new UnsupportedOperationException("\u6570\u636e\u4e0d\u5b8c\u6574");
                }
            } else {
                throw new UnsupportedOperationException("\u7f3a\u5c11\u4fc3\u9500\u653f\u7b56\u89c4\u5219");
            }
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        TpmPromotionPolicyTemplateConfigEntity entity = (TpmPromotionPolicyTemplateConfigEntity)((Object)this.tpmPromotionPolicyTemplateConfigEntityMapper.selectById((Serializable)((Object)dto.getId())));
        if (entity == null || !TenantUtils.getTenantCode().equals(entity.getTenantCode())) {
            throw new UnsupportedOperationException("\u672a\u627e\u5230\u4fc3\u9500\u653f\u7b56\u914d\u7f6e\u6a21\u677f\u6570\u636e");
        }
        entity.setBusinessFormatCode(dto.getBusinessFormatCode());
        entity.setBusinessUnitCode(dto.getBusinessUnitCode());
        entity.setPromotionPolicyTemplateName(dto.getPromotionPolicyTemplateName());
        entity.setPromotionType(dto.getPromotionType());
        this.tpmPromotionPolicyTemplateConfigEntityMapper.updateById((Object)entity);
        List<String> detailIdList = dto.getDetails().stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getId())).map(UuidDto::getId).collect(Collectors.toList());
        this.tpmPromotionPolicyTemplateConfigDetailEntityMapper.deleteDetailsByParentCodeNotInList(entity.getPromotionPolicyTemplateCode(), detailIdList, TenantUtils.getTenantCode());
        for (TpmPromotionPolicyTemplateConfigDetailDto detailDto : dto.getDetails()) {
            detailDto.setTenantCode(TenantUtils.getTenantCode());
            TpmPromotionPolicyTemplateConfigDetailEntity detailEntity = (TpmPromotionPolicyTemplateConfigDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)detailDto, TpmPromotionPolicyTemplateConfigDetailEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            if (StringUtils.isNotEmpty((CharSequence)detailEntity.getId())) {
                this.tpmPromotionPolicyTemplateConfigDetailEntityMapper.updateById((Object)detailEntity);
                continue;
            }
            detailEntity.setPromotionPolicyTemplateCode(entity.getPromotionPolicyTemplateCode());
            detailEntity.setTenantCode(TenantUtils.getTenantCode());
            this.tpmPromotionPolicyTemplateConfigDetailEntityMapper.insert((Object)detailEntity);
        }
        TpmPromotionPolicyTemplateConfigLogDto logDto = new TpmPromotionPolicyTemplateConfigLogDto();
        logDto.setNewest(dto);
        TpmPromotionPolicyTemplateConfigDto original = (TpmPromotionPolicyTemplateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmPromotionPolicyTemplateConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        logDto.setOriginal(original);
        this.tpmPromotionPolicyTemplateConfigLogEventListener.onUpdate(logDto);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01", (Object[])new Object[0]);
        List entityList = this.tpmPromotionPolicyTemplateConfigEntityMapper.selectBatchIds(ids);
        Validate.notEmpty((Collection)entityList, (String)"\u8981\u5220\u9664\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        List codes = entityList.stream().map(TpmPromotionPolicyTemplateConfigEntity::getPromotionPolicyTemplateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        SelectRelationPolicyEventDto eventDto = new SelectRelationPolicyEventDto();
        eventDto.setConfigCodes(codes);
        SerializableBiConsumer & Serializable hasRelationPolicyConfig = TpmPromotionPolicyTemplateConfigEventListener::hasRelationPolicyConfig;
        SelectRelationPolicyEventResponse response = (SelectRelationPolicyEventResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)eventDto, TpmPromotionPolicyTemplateConfigEventListener.class, (SerializableBiConsumer)hasRelationPolicyConfig);
        Validate.notNull((Object)response, (String)"\u67e5\u8be2\u662f\u5426\u6709\u89c4\u5212\u5173\u8054\u7740\u4fc3\u9500\u653f\u7b56\u5931\u8d25\uff01", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Map)response.getResp())) {
            Map resp = response.getResp();
            for (String key : resp.keySet()) {
                Validate.isTrue((boolean)((Boolean)resp.get(key)), (String)("\u4fc3\u9500\u6a21\u677f\u3010" + key + "\u3011,\u5df2\u6709\u4fc3\u9500\u653f\u7b56\u5728\u4f7f\u7528\uff0c\u4e0d\u53ef\u5220\u9664"), (Object[])new Object[0]);
            }
        }
        if (!CollectionUtils.isEmpty(ids)) {
            this.tpmPromotionPolicyTemplateConfigDetailEntityMapper.deleteByParentId(ids, TenantUtils.getTenantCode());
            this.tpmPromotionPolicyTemplateConfigEntityMapper.deleteByIdList(ids, TenantUtils.getTenantCode());
        }
        for (TpmPromotionPolicyTemplateConfigEntity entity : entityList) {
            if (entity == null) continue;
            TpmPromotionPolicyTemplateConfigDto original = (TpmPromotionPolicyTemplateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmPromotionPolicyTemplateConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            TpmPromotionPolicyTemplateConfigDto newest = new TpmPromotionPolicyTemplateConfigDto();
            BeanUtils.copyProperties((Object)original, (Object)newest);
            original.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            TpmPromotionPolicyTemplateConfigLogDto logDto = new TpmPromotionPolicyTemplateConfigLogDto();
            logDto.setOriginal(original);
            logDto.setNewest(newest);
            this.tpmPromotionPolicyTemplateConfigLogEventListener.onDelete(logDto);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            this.tpmPromotionPolicyTemplateConfigEntityMapper.enableByIds(ids, TenantUtils.getTenantCode());
        }
        for (String id : ids) {
            TpmPromotionPolicyTemplateConfigEntity entity = (TpmPromotionPolicyTemplateConfigEntity)((Object)this.tpmPromotionPolicyTemplateConfigEntityMapper.selectById((Serializable)((Object)id)));
            if (entity == null) continue;
            TpmPromotionPolicyTemplateConfigDto original = (TpmPromotionPolicyTemplateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmPromotionPolicyTemplateConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            TpmPromotionPolicyTemplateConfigLogDto logDto = new TpmPromotionPolicyTemplateConfigLogDto();
            logDto.setOriginal(original);
            this.tpmPromotionPolicyTemplateConfigLogEventListener.onEnable(logDto);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            this.tpmPromotionPolicyTemplateConfigEntityMapper.disableByIds(ids, TenantUtils.getTenantCode());
        }
        for (String id : ids) {
            TpmPromotionPolicyTemplateConfigEntity entity = (TpmPromotionPolicyTemplateConfigEntity)((Object)this.tpmPromotionPolicyTemplateConfigEntityMapper.selectById((Serializable)((Object)id)));
            if (entity == null) continue;
            TpmPromotionPolicyTemplateConfigDto original = (TpmPromotionPolicyTemplateConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmPromotionPolicyTemplateConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            TpmPromotionPolicyTemplateConfigLogDto logDto = new TpmPromotionPolicyTemplateConfigLogDto();
            logDto.setOriginal(original);
            this.tpmPromotionPolicyTemplateConfigLogEventListener.onDisable(logDto);
        }
    }
}

