package com.biz.crm.tpm.business.promotion.policy.template.config.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * @ClassName TpmPromotionPolicyTemplateConfigDto
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/1
 */
@Data
@ApiModel(value = "TpmPromotionPolicyTemplateConfigDto", description = "TPM-促销政策模板配置数据传输vo")
public class TpmPromotionPolicyTemplateConfigDto extends TenantFlagOpDto {

    /**
     * 促销政策模板id
     */
    @ApiModelProperty("促销政策模板id")
    private String id;

    /**
     * 促销政策模板编码
     */
    @ApiModelProperty("促销政策模板编码")
    private String promotionPolicyTemplateCode;

    /**
     * 促销政策模板名称
     */
    @ApiModelProperty("促销政策模板名称")
    private String promotionPolicyTemplateName;

    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    private String promotionType;

    /**
     * 业态
     */
    @ApiModelProperty("业态编码")
    private String businessFormatCode;

    /**
     * 业务单位编码
     */
    @ApiModelProperty("业务单位编码")
    private String businessUnitCode;

    /**
     * 删除标记
     */
    @ApiModelProperty("删除标记")
    private String delFlag;

    /**
     * 启用标记
     */
    @ApiModelProperty("启用标记")
    private String enableStatus;

    /**
     * 促销规则明细
     */
    @ApiModelProperty("促销规则明细")
    private List<TpmPromotionPolicyTemplateConfigDetailDto> details;

    public boolean validate(){
        return !StringUtils.isEmpty(promotionPolicyTemplateName)
                && !StringUtils.isEmpty(businessFormatCode)
                && !StringUtils.isEmpty(businessUnitCode)
                && !StringUtils.isEmpty(promotionType);
    }

}
