package com.biz.crm.tpm.business.promotion.policy.template.config.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @ClassName TpmPromotionPolicyTemplateConfigDetailRespVo
 * @Description
 * @Author: jiangyin
 * @Date 2022/11/1
 */
@Data
@ApiModel(value = "TpmPromotionPolicyTemplateConfigDetailRespVo", description = "TPM-促销政策模板配置规则明细返回vo")
public class TpmPromotionPolicyTemplateConfigDetailRespVo extends TenantFlagOpVo {

    /**
     * 促销政策模板编码
     */
    @ApiModelProperty(value = "促销政策模板编码", notes = "")
    private String promotionPolicyTemplateCode;

    /**
     * 条件类型
     */
    @ApiModelProperty(value = "条件类型", notes = "")
    private String typeCode;

    /**
     * 判断条件,数量/金额
     */
    @ApiModelProperty(value = "判断条件,数量/金额", notes = "")
    private BigDecimal promotionCondition;

    /**
     * 计算结果，数量/金额
     */
    @ApiModelProperty(value = "计算结果，数量/金额", notes = "")
    private BigDecimal promotionResult;

    /**
     * 计算规则编码，多个逗号隔开
     */
    @ApiModelProperty(value = "计算规则编码，多个逗号隔开", notes = "")
    private String calculateRule;

}
