package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.constant.PromotionProgressConstant;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.dto.PromotionProgressMonitorInDto;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.service.PromotionProgressMonitorInService;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.vo.PromotionProgressMonitorInVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 促销进度监控表（事中）(tpm_promotion_progress_monitor_in) 控制层
 *
 * @author : qiancheng
 * @date : 2022-11-18
 */
@RestController
@RequestMapping("/v1/promotionProgressMonitorIn")
@Slf4j
@Api(tags = "促销进度监控表（事中）")
public class PromotionProgressMonitorInController {

    @Autowired(required = false)
    private PromotionProgressMonitorInService progressMonitorInService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param promotionProgressMonitor 实体对象
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<PromotionProgressMonitorInVO>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
                                                                       @ApiParam(name = "promotionProgressMonitor", value = "促销进度监控表(事中)") PromotionProgressMonitorInDto promotionProgressMonitor) {
        try {
            Page<PromotionProgressMonitorInVO> page = this.progressMonitorInService.findByConditions(pageable, promotionProgressMonitor);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键id 查询单条数据
     *
     * @param id 主键id
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键id查询单条数据")
    @GetMapping("/findById")
    public Result<PromotionProgressMonitorInVO> findById(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
        try {
            PromotionProgressMonitorInVO progressMonitorInVO = progressMonitorInService.findById(id);
            return Result.ok(progressMonitorInVO);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增、更新 数据（审批通过的分子公司活动细案）
     * @param codes
     * @return
     */
    @ApiOperation(value = "新增、更新")
    @PostMapping("/createOrUpdateItemData")
    public Result<?> createOrUpdateItemData(@RequestParam("codes") @ApiParam(name = "codes", value = "codes") List<String> codes) {
        try {
            progressMonitorInService.createOrUpdateData(codes);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增、更新 数据（审批通过的垂直活动细案事中）
     * @param codes
     * @return
     */
    @ApiOperation(value = "新增、更新")
    @PostMapping("/createOrUpdateDataCz")
    public Result<?> createOrUpdateDataCz(@RequestParam(value = "codes",required = false) @ApiParam(name = "codes", value = "codes") List<String> codes,
                                          @RequestParam(value = "date",required = false) @ApiParam(name = "date", value = "date") String date) {
        boolean lockSuccess = false;
        try {
            lockSuccess = redisLockService.tryLock(PromotionProgressConstant.TPM_PROMOTION_PROGRESS_THINGS_LOCK, TimeUnit.HOURS, 6);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            progressMonitorInService.createOrUpdateDataCz(codes, date);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }finally {
            if (lockSuccess){
                redisLockService.unlock(PromotionProgressConstant.TPM_PROMOTION_PROGRESS_THINGS_LOCK);
            }
        }
    }

    /**
     * 新增、更新 数据（审批通过的垂直活动细案事后）
     * @param codes
     * @return
     */
    @ApiOperation(value = "新增、更新")
    @PostMapping("/createOrUpdateDataCzAfter")
    public Result<?> createOrUpdateDataCzAfter(@RequestParam(value = "codes",required = false) @ApiParam(name = "codes", value = "codes") List<String> codes,
                                               @RequestParam(value = "date",required = false) @ApiParam(name = "date", value = "date") String date) {
        boolean lockSuccess = false;
        try {
            lockSuccess = redisLockService.tryLock(PromotionProgressConstant.TPM_PROMOTION_PROGRESS_AFTER_LOCK, TimeUnit.HOURS, 6);
            Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
            progressMonitorInService.createOrUpdateDataCzAfter(codes, date);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }finally {
            if (lockSuccess){
                redisLockService.unlock(PromotionProgressConstant.TPM_PROMOTION_PROGRESS_AFTER_LOCK);
            }
        }
    }


    /**
     * 每日更新数据（费用进度等信息）
     */
    @ApiOperation(value = "每日更新数据", httpMethod = "POST")
    @PostMapping("/updateWithEveyDay")
    public void updateWithEveyDay() {
        try {
            this.progressMonitorInService.updateWithEveyDay();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

}
