package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 *  促销进度监控表(事中) DataView
 *  * @author qiancheng
 *  * @since 2022-11-18
 */
@Component
public class PromotionProgressMonitorInDateView implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_promotion_progress_monitor_in";
    }

    @Override
    public String desc() {
        return "TPM-促销进度监控表(事中)";
    }

    @Override
    public String buildSql() {
        return "SELECT t.* FROM tpm_promotion_progress_monitor_in t" +
                "  WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' "+
                "  AND t.tenant_code = :tenantCode ";
    }
}
