package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 实体：促销进度监控表（垂直事中）
 *
 * @author miaoqiancheng
 * @since 2022-11-18
 */
@ApiModel(value = "PromotionProgressMonitorCz", description = "促销进度监控表(垂直事中)")
@TableName("tpm_promotion_progress_monitor_cz")
@EqualsAndHashCode(callSuper = false)
@Data
@Entity(name = "tpm_promotion_progress_monitor_cz")
@org.hibernate.annotations.Table(appliesTo = "tpm_promotion_progress_monitor_cz", comment = "促销进度监控表(垂直)")
@Table(name = "tpm_promotion_progress_monitor_cz", indexes = {@Index(name = "tpm_promotion_progress_cz_inx1", columnList = "activity_detail_item_code", unique = false)})
public class PromotionProgressMonitorCz extends TenantFlagOpEntity {

    @ApiModelProperty(name = "feeYearMonth",value = "费用所属年月",notes = "费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", nullable = true,length = 20, columnDefinition = "datetime COMMENT '费用所属年月'")
    private Date feeYearMonth;

    @ApiModelProperty(name = "businessFormatCode",value = "业态编码",notes = "业态编码")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态编码'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    @Column(name = "sales_institution_name", columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty(name = "活动细案编码", notes = "活动细案编码")
    @Column(name = "activity_detail_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案编码'")
    private String activityDetailCode;

    @ApiModelProperty(name = "活动细案名称", notes = "活动细案名称")
    @Column(name = "activity_detail_name", nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '活动细案名称'")
    private String activityDetailName;

    @ApiModelProperty(name = "活动细案明细编码", notes = "活动细案明细编码")
    @Column(name = "activity_detail_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动细案明细编码'")
    private String activityDetailItemCode;

    @ApiModelProperty(name = "activityStatus",value = "活动状态",notes = "活动状态")
    @Column(name = "activity_status", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动状态'")
    private String activityStatus;

    @ApiModelProperty(name = "auditType",value = "核销方式",notes = "核销方式")
    @Column(name = "audit_type", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销方式'")
    private String auditType;

    @ApiModelProperty(name = "activityType",value = "活动类型",notes = "活动类型")
    @Column(name = "activity_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动类型'")
    private String activityType;

    @ApiModelProperty(name = "activityTypeName",value = "活动类型名称",notes = "活动类型名称")
    @Column(name = "activity_type_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动类型名称'")
    private String activityTypeName;

    @ApiModelProperty(name = "activityForm",value = "活动形式",notes = "活动形式")
    @Column(name = "activity_form", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式'")
    private String activityForm;

    @ApiModelProperty(name = "activityBeginTime",value = "活动开始时间",notes = "活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_time", nullable = true,length = 20, columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginTime;

    @ApiModelProperty(name = "activityEndTime",value = "活动结束时间",notes = "活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_time", nullable = true,length = 20, columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndTime;

    @ApiModelProperty(name = "regionCode",value = "区域",notes = "区域")
    @Column(name = "region_code", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '区域'")
    private String regionCode;

    @ApiModelProperty(name = "regionName",value = "区域",notes = "区域")
    @Column(name = "region_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '区域'")
    private String regionName;

    @ApiModelProperty(name = "systemCode",value = "零售商",notes = "零售商")
    @Column(name = "system_code", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '零售商'")
    private String systemCode;

    @ApiModelProperty(name = "systemName",value = "零售商名称",notes = "零售商名称")
    @Column(name = "system_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '零售商'")
    private String systemName;

    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "customerCode",value = "客户名称",notes = "客户名称")
    @Column(name = "customer_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "brandCode",value = "品牌编码",notes = "品牌编码")
    @Column(name = "brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String brandCode;

    @ApiModelProperty(name = "brandName",value = "品牌名称",notes = "品牌名称")
    @Column(name = "brand_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品牌名称'")
    private String brandName;

    @ApiModelProperty(name = "productItemCode",value = "产品品项编码",notes = "产品品项编码")
    @Column(name = "product_item_code", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品品项编码'")
    private String productItemCode;

    @ApiModelProperty(name = "productItemName",value = "产品品项名称",notes = "产品品项名称")
    @Column(name = "product_item_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品品项名称'")
    private String productItemName;

    @ApiModelProperty(name = "productCategoryCode",value = "产品品类编码",notes = "产品品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品品类编码'")
    private String productCategoryCode;

    @ApiModelProperty(name = "productCategoryName",value = "产品品类名称",notes = "产品品类名称")
    @Column(name = "product_category_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品品类名称'")
    private String productCategoryName;

    @ApiModelProperty(name = "productCode",value = "产品编码",notes = "产品编码")
    @Column(name = "product_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "productName",value = "产品名称",notes = "产品名称")
    @Column(name = "product_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(name = "applicationPromotionVolume",value = "申请促销量",notes = "申请促销量")
    @Column(name = "application_promotion_volume", nullable = true, columnDefinition = "int COMMENT '申请促销量'")
    private BigDecimal applicationPromotionVolume;


    @ApiModelProperty(name = "actualExecutionVolume",value = "已发生促销量",notes = "实际执行量")
    @Column(name = "actual_execution_volume", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '已发生促销量'")
    private BigDecimal actualExecutionVolume;

    @ApiModelProperty(name = "remainingSalesPromotion",value = "剩余促销量",notes = "剩余促销量")
    @Column(name = "remaining_sales_promotion", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '剩余促销量'")
    private BigDecimal remainingSalesPromotion;

    @ApiModelProperty(name = "applicationFee",value = "申请费用",notes = "申请费用")
    @Column(name = "application_fee", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '申请金额'")
    private BigDecimal applicationFee;

    @ApiModelProperty(name = "estimatedExpenseFee",value = "预计发生费用",notes = "预计发生费用")
    @Column(name = "estimated_expense_fee", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '预计发生费用'")
    private BigDecimal estimatedExpenseFee;

    @ApiModelProperty(name = "surplusActivityFee",value = "活动剩余费用",notes = "活动剩余费用")
    @Column(name = "surplus_activity_fee", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '活动剩余费用'")
    private BigDecimal surplusActivityFee;

    @ApiModelProperty(name = "costProgress",value = "费用进度",notes = "费用进度")
    @Column(name = "cost_progress", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '费用进度'")
    private BigDecimal costProgress;

    @ApiModelProperty(value = "门店编码", notes = "")
    @Column(name = "terminal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码 '")
    private String terminalCode;

    @ApiModelProperty(value = "门店名称", notes = "")
    @Column(name = "terminal_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '门店名称 '")
    private String terminalName;

    @ApiModelProperty(name = "预警状态", notes = "预警状态")
    @Column(name = "warn_type", length = 32, columnDefinition = "varchar(32) COMMENT '预警状态'")
    private String warnType;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    @Column(name = "write_off_method", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '核销方式'")
    private String writeOffMethod;

}
