package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 实体：促销进度监控表（事中）
 *
 * @author miaoqiancheng
 * @since 2022-11-18
 */
@ApiModel(value = "PromotionProgressMonitorIn", description = "活动进度监控表(事中)")
@TableName("tpm_promotion_progress_monitor_in")
@EqualsAndHashCode(callSuper = false)
@Data
@Entity(name = "tpm_promotion_progress_monitor_in")
@org.hibernate.annotations.Table(appliesTo = "tpm_promotion_progress_monitor_in", comment = "活动进度监控表(事中)")
@Table(name = "tpm_promotion_progress_monitor_in", indexes = {@Index(name = "tpm_promotion_progress_in_inx1", columnList = "activity_detail_plan_code", unique = false)})
public class PromotionProgressMonitorIn extends TenantFlagOpEntity {

    @ApiModelProperty(name = "feeYearMonth",value = "费用所属年月",notes = "费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", nullable = true,length = 20, columnDefinition = "datetime COMMENT '费用所属年月'")
    private Date feeYearMonth;

    @ApiModelProperty(name = "businessFormatCode",value = "业态编码",notes = "业态编码")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态编码'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "orgCode",value = "组织编码",notes = "组织编码")
    @Column(name = "org_code", length = 32, columnDefinition = "VARCHAR(64) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty(name = "orgName",value = "组织名称",notes = "组织名称")
    @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty(name = "salesOrgCode",value = "销售部门编码",notes = "销售部门编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "salesOrgName",value = "销售部门名称",notes = "销售部门名称")
    @Column(name = "sales_org_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售部门名称'")
    private String salesOrgName;

    @ApiModelProperty(name = "activityDetailPlanCode",value = "活动细案编码",notes = "活动细案编码")
    @Column(name = "activity_detail_plan_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动细案编码'")
    private String activityDetailPlanCode;

    @ApiModelProperty(name = "activityDetailPlanName",value = "活动细案名称",notes = "活动细案名称")
    @Column(name = "activity_detail_plan_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动细案名称'")
    private String activityDetailPlanName;

    @ApiModelProperty(name = "activityDetailCode",value = "活动明细编码",notes = "活动明细编码")
    @Column(name = "activity_detail_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动明细编码'")
    private String activityDetailCode;

    @ApiModelProperty(name = "activityStatus",value = "活动状态",notes = "活动状态")
    @Column(name = "activity_status", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动状态'")
    private String activityStatus;

    @ApiModelProperty(name = "auditType",value = "核销方式",notes = "核销方式")
    @Column(name = "audit_type", nullable = true,length = 10, columnDefinition = "VARCHAR(10) COMMENT '核销方式'")
    private String auditType;

    @ApiModelProperty(name = "activityType",value = "活动类型",notes = "活动类型")
    @Column(name = "activity_type", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动类型'")
    private String activityType;

    @ApiModelProperty(name = "activityForm",value = "活动形式",notes = "活动形式")
    @Column(name = "activity_form", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式'")
    private String activityForm;

    @ApiModelProperty(name = "activityBeginTime",value = "活动开始时间",notes = "活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_time", nullable = true,length = 20, columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginTime;

    @ApiModelProperty(name = "activityEndTime",value = "活动结束时间",notes = "活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_time", nullable = true,length = 20, columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndTime;

    @ApiModelProperty(name = "system",value = "系统",notes = "系统")
    @Column(name = "system", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '系统'")
    private String system;

    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    @Column(name = "customer_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "customerCode",value = "客户名称",notes = "客户名称")
    @Column(name = "customer_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "brandCode",value = "品牌编码",notes = "品牌编码")
    @Column(name = "brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String brandCode;

    @ApiModelProperty(name = "brandName",value = "品牌名称",notes = "品牌名称")
    @Column(name = "brand_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '品牌名称'")
    private String brandName;

    @ApiModelProperty(name = "productItemCode",value = "产品品项编码",notes = "产品品项编码")
    @Column(name = "product_item_code", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品品项编码'")
    private String productItemCode;

    @ApiModelProperty(name = "productItemName",value = "产品品项名称",notes = "产品品项名称")
    @Column(name = "product_item_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品品项名称'")
    private String productItemName;

    @ApiModelProperty(name = "productCategoryCode",value = "产品品类编码",notes = "产品品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品品类编码'")
    private String productCategoryCode;

    @ApiModelProperty(name = "productCategoryName",value = "产品品类名称",notes = "产品品类名称")
    @Column(name = "product_category_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品品类名称'")
    private String productCategoryName;

    @ApiModelProperty(name = "promotionRule",value = "促销规则",notes = "促销规则")
    @Column(name = "promotion_rule", nullable = true, length = 32, columnDefinition = "VARCHAR(255) COMMENT '促销规则'")
    private String promotionRule;

    @ApiModelProperty(name = "applicationPromotionVolume",value = "申请促销量",notes = "申请促销量")
    @Column(name = "application_promotion_volume", nullable = true, columnDefinition = "int COMMENT '申请促销量'")
    private Integer applicationPromotionVolume;

    @ApiModelProperty(name = "applicationFee",value = "申请金额",notes = "申请金额")
    @Column(name = "application_fee", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '申请金额'")
    private BigDecimal applicationFee;

    @ApiModelProperty(name = "estimatedExpenseFee",value = "预计发生费用",notes = "预计发生费用")
    @Column(name = "estimated_expense_fee", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '预计发生费用'")
    private BigDecimal estimatedExpenseFee;

    @ApiModelProperty(name = "surplusActivityFee",value = "活动剩余费用",notes = "活动剩余费用")
    @Column(name = "surplus_activity_fee", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '活动剩余费用'")
    private BigDecimal surplusActivityFee;

    @ApiModelProperty(name = "costProgress",value = "费用进度",notes = "费用进度")
    @Column(name = "cost_progress", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '费用进度'")
    private BigDecimal costProgress;




}
