package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.entity.PromotionProgressMonitorCz;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.mapper.PromotionProgressMonitorCzMapper;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.dto.PromotionProgressCzWarningQueryDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 促销进度监控表(事中)(tpm_promotion_progress_monitor_Cz)数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-18
 */
@Component
public class PromotionProgressMonitorCzRepository extends ServiceImpl<PromotionProgressMonitorCzMapper, PromotionProgressMonitorCz> {

    @Override
    public boolean saveOrUpdateBatch(Collection<PromotionProgressMonitorCz> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList)){
            return true;
        }
        List<List<PromotionProgressMonitorCz>> partition = Lists.partition(Lists.newArrayList(entityList), batchSize);
        for (List<PromotionProgressMonitorCz> list : partition) {
            List<String> idList = entityList.stream().map(PromotionProgressMonitorCz::getId).collect(Collectors.toList());
            List<PromotionProgressMonitorCz> existEntityList = this.listByIds(idList);
            List<String> existIdList = existEntityList.stream().map(PromotionProgressMonitorCz::getId).collect(Collectors.toList());
            List<PromotionProgressMonitorCz> saveList = Lists.newArrayList();
            List<PromotionProgressMonitorCz> updateList = Lists.newArrayList();
            for (PromotionProgressMonitorCz entity : list) {
                if (null != entity.getId() && existIdList.contains(entity.getId())){
                    updateList.add(entity);
                }else{
                    saveList.add(entity);
                }
            }
            if (!CollectionUtils.isEmpty(saveList)){
                baseMapper.insertBatchSomeColumn(saveList);
            }
            if (!CollectionUtils.isEmpty(updateList)){
                this.updateBatchById(updateList);
            }
        }
        return true;
    }

    public List<Map<String, Object>> findPromotionProgressMonitorCzWarning(PromotionProgressCzWarningQueryDto dto) {
        dto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setYearAndMonth(DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH));
        dto.setYearMonthDay(DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH_DAY));
        return this.baseMapper.findPromotionProgressMonitorCzWarning(dto);
    }
}
