package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.entity.PromotionProgressMonitorIn;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.mapper.PromotionProgressMonitorInMapper;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.dto.PromotionProgressMonitorInDto;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.vo.PromotionProgressMonitorInVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * 促销进度监控表(事中)(tpm_promotion_progress_monitor_in)数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-18
 */
@Component
public class PromotionProgressMonitorInRepository extends ServiceImpl<PromotionProgressMonitorInMapper, PromotionProgressMonitorIn> {

    @Autowired
    private PromotionProgressMonitorInMapper promotionProgressMonitorInMapper;

    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param progressMonitorIn 实体对象
     */
    public Page<PromotionProgressMonitorInVO> findByConditions(Pageable pageable, PromotionProgressMonitorInDto progressMonitorIn){
        if(pageable == null){
            pageable = PageRequest.of(1,50);
        }
        Page<PromotionProgressMonitorInVO> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<PromotionProgressMonitorInVO> byConditions = this.promotionProgressMonitorInMapper.findByConditions(page, progressMonitorIn);
        List<PromotionProgressMonitorInVO> monitorInVoList = byConditions.getRecords();
        monitorInVoList.forEach(monitorInVo ->{
            long beginTime = monitorInVo.getActivityBeginTime().getTime();
            long endTime = monitorInVo.getActivityEndTime().getTime();
            long currentTime = new Date().getTime();
            monitorInVo.setTimeSchedule((endTime - beginTime) / (currentTime - beginTime));

            //已发生促销量、剩余促销量、执行进度
        });
        return byConditions;
    }

}
