package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigDetailVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.entity.PromotionProgressMonitorCz;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.entity.PromotionProgressMonitorIn;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.repository.PromotionProgressMonitorCzRepository;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.repository.PromotionProgressMonitorInRepository;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.dto.PromotionProgressMonitorInDto;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.service.PromotionProgressMonitorInService;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.vo.PromotionProgressMonitorInVO;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 活动进度监控表(事中)(tpm_promotion_progress_monitor_in)服务实现类
 *
 * @author : qiancheng
 * @date : 2022-11-18
 */
@Slf4j
@Service
public class PromotionProgressMonitorServiceInImpl implements PromotionProgressMonitorInService {

    private final String SAP = "SAP";

    @Autowired(required = false)
    private PromotionProgressMonitorInRepository promotionProgressMonitorInRepository;

    @Autowired(required = false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Autowired(required = false)
    private PromotionProgressMonitorCzRepository promotionProgressMonitorCzRepository;

    @Autowired(required = false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    /**
     * 分页查询数据
     *
     * @param pageable                   分页对象
     * @param promotionProgressMonitorIn 实体对象
     * @return 分页对象
     */
    @Override
    public Page<PromotionProgressMonitorInVO> findByConditions(Pageable pageable, PromotionProgressMonitorInDto promotionProgressMonitorIn) {
        if (pageable == null) {
            pageable = PageRequest.of(1, 20);
        }
        if (promotionProgressMonitorIn == null) {
            promotionProgressMonitorIn = new PromotionProgressMonitorInDto();
        }
        return this.promotionProgressMonitorInRepository.findByConditions(pageable, promotionProgressMonitorIn);

    }

    /**
     * 通过主键id查询单条数据
     *
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public PromotionProgressMonitorInVO findById(String id) {
        if (!StringUtils.isBlank(id)) {
            PromotionProgressMonitorIn progressMonitorIn = promotionProgressMonitorInRepository.getById(id);
            return nebulaToolkitService.copyObjectByWhiteList(progressMonitorIn, PromotionProgressMonitorInVO.class, HashSet.class, ArrayList.class);
        }
        return null;
    }


    /**
     * 新赠/更新 审批通过的细案明细数据
     *
     * @param codes 分子公司细案编码
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void createOrUpdateData(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        List<PromotionProgressMonitorIn> entityList = new ArrayList<>();
        //审批通过的细案集合
        List<SubComActivityDetailPlanVo> detailPlanList = subComActivityDetailPlanVoService.findDetailPlanAndItemByPlanCode(codes);
        detailPlanList.forEach(detailPlan -> {
            if (!CollectionUtils.isEmpty(detailPlan.getItemList())) {
                //细案明细
                List<SubComActivityDetailPlanItemVo> detailPlanItemList = detailPlan.getItemList();
                //取细案预测中的预测金额
                Set<String> detailPlanItemCodes = detailPlanItemList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
                List<DetailedForecastVo> byActivityDetailItemCode = detailedForecastService.findByActivityDetailItemCode(detailPlanItemCodes);
                Map<String, BigDecimal> estimatedExpenseFeeMap = byActivityDetailItemCode.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, DetailedForecastVo::getEstimatedWriteOffAmount));

                detailPlanItemList.forEach(detailPlanItemVo -> {
                    PromotionProgressMonitorIn progressMonitorIn = new PromotionProgressMonitorIn();
                    progressMonitorIn.setId(detailPlanItemVo.getConstituentDetailPlanItemCode());

                    progressMonitorIn.setFeeYearMonth(detailPlanItemVo.getFeeYearMonth());
                    progressMonitorIn.setBusinessFormatCode(detailPlan.getBusinessFormatCode());
                    progressMonitorIn.setOrgCode(detailPlan.getOrgCode());
                    progressMonitorIn.setOrgName(detailPlan.getOrgName());
                    progressMonitorIn.setSalesOrgCode(detailPlan.getSalesOrgCode());
                    progressMonitorIn.setSalesOrgName(detailPlan.getSalesOrgName());
                    progressMonitorIn.setActivityDetailPlanCode(detailPlanItemVo.getConstituentDetailPlanCode());
                    progressMonitorIn.setActivityDetailPlanName(detailPlanItemVo.getConstituentDetailPlanName());
                    progressMonitorIn.setActivityDetailCode(detailPlanItemVo.getConstituentDetailPlanItemCode());
                    progressMonitorIn.setActivityStatus(detailPlanItemVo.getActivityStatus());
                    progressMonitorIn.setAuditType(detailPlanItemVo.getAuditType());
                    progressMonitorIn.setActivityType(detailPlanItemVo.getActivityType());
                    progressMonitorIn.setActivityForm(detailPlanItemVo.getActivityFormName());
                    progressMonitorIn.setActivityBeginTime(detailPlanItemVo.getActivityBeginTime());
                    progressMonitorIn.setActivityEndTime(detailPlanItemVo.getActivityEndTime());
                    progressMonitorIn.setCustomerCode(detailPlanItemVo.getCustomerCode());
                    progressMonitorIn.setCustomerName(detailPlanItemVo.getCustomerName());
                    progressMonitorIn.setBrandCode(detailPlanItemVo.getProductBrandCode());
                    progressMonitorIn.setBrandName(detailPlanItemVo.getProductBrandName());
                    progressMonitorIn.setProductItemCode(detailPlanItemVo.getProductItemCode());
                    progressMonitorIn.setProductItemName(detailPlanItemVo.getProductItemName());
                    progressMonitorIn.setProductCategoryCode(detailPlanItemVo.getProductCategoryCode());
                    progressMonitorIn.setProductCategoryName(detailPlanItemVo.getProductCategoryName());
                    String promoteSales = detailPlanItemVo.getPromoteSales().toString();
                    progressMonitorIn.setApplicationPromotionVolume(Integer.parseInt(promoteSales.substring(0, promoteSales.indexOf("."))));
                    progressMonitorIn.setApplicationFee(detailPlanItemVo.getTotalCost());
                    BigDecimal estimatedExpenseFee = estimatedExpenseFeeMap.get(detailPlanItemVo.getConstituentDetailPlanItemCode());
                    progressMonitorIn.setEstimatedExpenseFee(estimatedExpenseFee);
                    progressMonitorIn.setSurplusActivityFee(detailPlanItemVo.getTotalCost().subtract(estimatedExpenseFee));
                    progressMonitorIn.setCostProgress(estimatedExpenseFee.divide(detailPlanItemVo.getTotalCost(), 20, BigDecimal.ROUND_HALF_UP));
                    progressMonitorIn.setTenantCode(TenantUtils.getTenantCode());
                    progressMonitorIn.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    entityList.add(progressMonitorIn);
                });
            }

        });

        promotionProgressMonitorInRepository.saveOrUpdateBatch(entityList);
    }

    @Override
    public void createOrUpdateDataCz(List<String> codes, String date) {
        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        if (!CollectionUtils.isEmpty(codes)) {
            activityDetailPlanItemDto.setDetailPlanItemCodeList(codes);
        }

        //审批通过的细案集合
        List<ActivityDetailPlanItemVo> planItemVoList = new ArrayList<>();
        PageRequest pageRequest = PageRequest.of(1, 200);
        activityDetailPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activityDetailPlanItemDto.setTenantCode(TenantUtils.getTenantCode());
        activityDetailPlanItemDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        if (StringUtils.isNotEmpty(date)) {
            activityDetailPlanItemDto.setNowTime(date);
        } else {
            activityDetailPlanItemDto.setNowTime(DateUtil.dateStrNowYYYYMMDD());
        }
        activityDetailPlanItemDto.setWriteOffMethod(WriteOffMethodEnum.THINGS.getCode());
        activityDetailPlanItemDto.setTypeCodes(Stream.of("Z0006","Z0048","Z0021").collect(Collectors.toList()));
        Page<ActivityDetailPlanItemVo> itemVoPage = null;
        List<PromotionProgressMonitorCz> entityList = new ArrayList<>();
        do {
            itemVoPage = activityDetailPlanItemSdkService.findByConditions(pageRequest, activityDetailPlanItemDto);
            log.info("促销进度监控表(垂直事中)查询[{}/{}]",itemVoPage.getCurrent(),itemVoPage.getPages());
            pageRequest = pageRequest.next();
            planItemVoList = itemVoPage.getRecords();
            if (CollectionUtils.isEmpty(planItemVoList)) {
                return;
            }
            Set<String> detailPlanItemCodes = planItemVoList.stream().map(ActivityDetailPlanItemVo::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
            //预计发生费用不去细案预测取，直接等于已发生促销量*单件申请费用
            List<ActivityDetailPlanItemVo> byActivityDetailItemCodes = this.activityDetailPlanItemSdkService.findByActivityDetailItemCodes(detailPlanItemCodes);

            List<DetailedForecastVo> byActivityDetailItemCode = detailedForecastService.findByActivityDetailItemCode(detailPlanItemCodes);
            Map<String, BigDecimal> estimatedExpenseFeeMap = byActivityDetailItemCode.stream()
                    .filter(item -> Objects.nonNull(item.getEstimatedWriteOffAmount()))
                    .collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode,
                            DetailedForecastVo::getEstimatedWriteOffAmount, (n, o) -> n));
            //执行指标数据
            List<AuditExecuteIndicatorVo> auditExecuteIndicatorList = Optional.ofNullable(this.auditExecuteIndicatorService.findByActiveNumber(detailPlanItemCodes.stream().collect(Collectors.toList()), SAP, BusinessUnitEnum.VERTICAL.getCode())).orElse(new ArrayList<>());
            Map<String, List<AuditExecuteIndicatorVo>> auditExecuteIndicatorMap = auditExecuteIndicatorList.stream().collect(Collectors.groupingBy(AuditExecuteIndicatorVo::getActiveNumber));
            entityList.clear();
            planItemVoList.forEach(detailPlan -> {
                //取细案预测中的预测金额
                PromotionProgressMonitorCz progressMonitorCz = new PromotionProgressMonitorCz();
                progressMonitorCz.setId(detailPlan.getDetailPlanItemCode());
                progressMonitorCz.setFeeYearMonth(detailPlan.getFeeYearMonth());
                progressMonitorCz.setBusinessFormatCode(detailPlan.getBusinessFormatCode());
                progressMonitorCz.setBusinessUnitCode(detailPlan.getBusinessUnitCode());
                progressMonitorCz.setTerminalCode(detailPlan.getTerminalCode());
                progressMonitorCz.setTerminalName(detailPlan.getTerminalName());
                progressMonitorCz.setSalesInstitutionCode(detailPlan.getActivityOrgCode());
                progressMonitorCz.setSalesInstitutionName(detailPlan.getActivityOrgName());
                progressMonitorCz.setActivityDetailCode(detailPlan.getDetailPlanCode());
                progressMonitorCz.setActivityDetailName(detailPlan.getDetailPlanName());
                progressMonitorCz.setActivityDetailItemCode(detailPlan.getDetailPlanItemCode());
                progressMonitorCz.setActivityStatus(detailPlan.getPlanStatus());
                progressMonitorCz.setAuditType(detailPlan.getAuditType());
                progressMonitorCz.setActivityType(detailPlan.getActivityTypeCode());
                progressMonitorCz.setActivityTypeName(detailPlan.getActivityTypeName());
                progressMonitorCz.setActivityForm(detailPlan.getActivityFormName());
                progressMonitorCz.setActivityBeginTime(detailPlan.getActivityBeginDate());
                progressMonitorCz.setActivityEndTime(detailPlan.getActivityEndDate());
                progressMonitorCz.setCustomerCode(detailPlan.getCustomerCode());
                progressMonitorCz.setCustomerName(detailPlan.getCustomerName());
                progressMonitorCz.setBrandCode(detailPlan.getProductBrandCode());
                progressMonitorCz.setBrandName(detailPlan.getProductBrandName());
                progressMonitorCz.setProductItemCode(detailPlan.getProductItemCode());
                progressMonitorCz.setProductItemName(detailPlan.getProductItemName());
                progressMonitorCz.setProductCode(detailPlan.getProductCode());
                progressMonitorCz.setProductName(detailPlan.getProductName());
                progressMonitorCz.setProductCategoryCode(detailPlan.getProductCategoryCode());
                progressMonitorCz.setProductCategoryName(detailPlan.getProductCategoryName());
                progressMonitorCz.setSystemCode(detailPlan.getSystemCode());
                progressMonitorCz.setSystemName(detailPlan.getSystemName());
                progressMonitorCz.setRegionCode(detailPlan.getRegion());
                progressMonitorCz.setRegionName(detailPlan.getRegionName());
                progressMonitorCz.setWriteOffMethod(detailPlan.getWriteOffMethod());
                //申请数量在没有门店共用时，取期间促销件数；在有门店共用量时，取浮动量为申请数量
                if (BooleanEnum.FALSE.getCapital().equals(detailPlan.getPublicOrNot())){
                    progressMonitorCz.setApplicationPromotionVolume(new BigDecimal(Optional.ofNullable(detailPlan.getPeriodPromotionalNumber()).orElse(0)));

                }else {
                    progressMonitorCz.setApplicationPromotionVolume(Optional.ofNullable(detailPlan.getFloatingNumber()).orElse(BigDecimal.ZERO));
                }
                //申请费用在没有门店共用时，取费用合计；在有门店共用量时，取浮动金额为申请金额
                if (BooleanEnum.FALSE.getCapital().equals(detailPlan.getPublicOrNot())){
                    progressMonitorCz.setApplicationFee(Optional.ofNullable(detailPlan.getTotalFeeAmount()).orElse(BigDecimal.ZERO));

                }else {
                    progressMonitorCz.setApplicationFee(Optional.ofNullable(detailPlan.getFloatingAmount()).orElse(BigDecimal.ZERO));
                }
                BigDecimal estimatedExpenseFee = estimatedExpenseFeeMap.get(detailPlan.getDetailPlanItemCode());
                List<AuditExecuteIndicatorVo> auditExecuteIndicatorVos = auditExecuteIndicatorMap.get(detailPlan.getDetailPlanItemCode());
                BigDecimal actualExecutionVolume = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty(auditExecuteIndicatorVos)) {
                    BigDecimal bigDecimal = Optional.of(auditExecuteIndicatorVos.stream()
                            .filter(item -> IndicatorNameEnum.SAP_QUANTITY.getCode().equals(item.getIndicatorName()))
                            .map(AuditExecuteIndicatorVo::getIndicatorValue)
                            .filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO);
                    actualExecutionVolume = actualExecutionVolume.add(bigDecimal);
                }
                progressMonitorCz.setEstimatedExpenseFee(Optional.ofNullable(estimatedExpenseFee).orElse(BigDecimal.ZERO));
                //事中活动取SAP104数据
                progressMonitorCz.setActualExecutionVolume(Optional.ofNullable(actualExecutionVolume).orElse(BigDecimal.ZERO));
                //预计发生费用不去细案预测取，直接等于已发生促销量*单件申请费用
                if (!CollectionUtils.isEmpty(byActivityDetailItemCodes)){
                    Map<String, BigDecimal> collect = byActivityDetailItemCodes.stream().collect(Collectors.toMap(ActivityDetailPlanItemVo::getDetailPlanItemCode, item-> Optional.ofNullable(item.getOriginalPriceGift()).orElse(BigDecimal.ZERO)));
                    progressMonitorCz.setEstimatedExpenseFee(Optional.ofNullable(collect.get(detailPlan.getDetailPlanItemCode())).orElse(BigDecimal.ZERO).multiply(progressMonitorCz.getActualExecutionVolume()));
                }

                progressMonitorCz.setApplicationPromotionVolume(Optional.ofNullable(progressMonitorCz.getApplicationPromotionVolume()).orElse(BigDecimal.ZERO));

                progressMonitorCz.setRemainingSalesPromotion(progressMonitorCz.getApplicationPromotionVolume().subtract(progressMonitorCz.getActualExecutionVolume()));
                progressMonitorCz.setSurplusActivityFee(progressMonitorCz.getApplicationFee().subtract(Optional.ofNullable(estimatedExpenseFee).orElse(BigDecimal.ZERO)));
                if (BigDecimal.ZERO.compareTo(progressMonitorCz.getApplicationFee()) != 0) {
                    progressMonitorCz.setCostProgress(progressMonitorCz.getEstimatedExpenseFee().divide(progressMonitorCz.getApplicationFee(), 20, BigDecimal.ROUND_HALF_UP));
                } else {
                    progressMonitorCz.setCostProgress(BigDecimal.ZERO);
                }
                if (BigDecimal.ZERO.compareTo(progressMonitorCz.getCostProgress()) <= 0) {
                    progressMonitorCz.setWarnType("预警");
                } else {
                    progressMonitorCz.setWarnType("正常");
                }
                progressMonitorCz.setTenantCode(TenantUtils.getTenantCode());
                progressMonitorCz.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entityList.add(progressMonitorCz);
            });
            this.saveOrUpdateMonitorCz(entityList, null);

        } while (itemVoPage.hasNext());

    }

    /**
     * @param entityList 促销进度监控实体
     * @param idList     活动细案明细ID
     * @return void
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023-09-16 21:04
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdateMonitorCz(List<PromotionProgressMonitorCz> entityList, List<String> idList) {
        if (CollectionUtil.isNotEmpty(entityList)) {
            promotionProgressMonitorCzRepository.saveOrUpdateBatch(entityList);
        }
    }

    @Override
    public void createOrUpdateDataCzAfter(List<String> codes, String date) {
        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        if (!CollectionUtils.isEmpty(codes)) {
            activityDetailPlanItemDto.setDetailPlanItemCodeList(codes);
        }
        //审批通过的细案集合
        List<ActivityDetailPlanItemVo> planItemVoList = new ArrayList<>();
        PageRequest pageRequest = PageRequest.of(1, 200);
        activityDetailPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activityDetailPlanItemDto.setTenantCode(TenantUtils.getTenantCode());
        activityDetailPlanItemDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        activityDetailPlanItemDto.setWriteOffMethod(WriteOffMethodEnum.AFTER_THE_EVENT.getCode());
        if (StringUtils.isNotEmpty(date)) {
            activityDetailPlanItemDto.setNowTime(date);
        } else {
            activityDetailPlanItemDto.setNowTime(DateUtil.dateStrNowYYYYMMDD());
        }
        activityDetailPlanItemDto.setTypeCodes(Stream.of("Z0006","Z0048","Z0021").collect(Collectors.toList()));
        Page<ActivityDetailPlanItemVo> itemVoPage = null;
        List<PromotionProgressMonitorCz> entityList = new ArrayList<>();
        do {
            itemVoPage = activityDetailPlanItemSdkService.findByConditions(pageRequest, activityDetailPlanItemDto);
            log.info("促销进度监控表(垂直事后)查询[{}/{}]",itemVoPage.getCurrent(),itemVoPage.getPages());
            pageRequest = pageRequest.next();
            planItemVoList = itemVoPage.getRecords();
            if (CollectionUtils.isEmpty(planItemVoList)) {
                return;
            }

            SalesDataDto dto = new SalesDataDto();
            entityList.clear();
            planItemVoList.forEach(detailPlan -> {
                PromotionProgressMonitorCz progressMonitorCz = new PromotionProgressMonitorCz();
                progressMonitorCz.setId(detailPlan.getDetailPlanItemCode());
                progressMonitorCz.setFeeYearMonth(detailPlan.getFeeYearMonth());
                progressMonitorCz.setBusinessFormatCode(detailPlan.getBusinessFormatCode());
                progressMonitorCz.setBusinessUnitCode(detailPlan.getBusinessUnitCode());
                progressMonitorCz.setSalesInstitutionCode(detailPlan.getActivityOrgCode());
                progressMonitorCz.setSalesInstitutionName(detailPlan.getActivityOrgName());
                progressMonitorCz.setActivityDetailCode(detailPlan.getDetailPlanCode());
                progressMonitorCz.setActivityDetailName(detailPlan.getDetailPlanName());
                progressMonitorCz.setActivityDetailItemCode(detailPlan.getDetailPlanItemCode());
                progressMonitorCz.setActivityStatus(detailPlan.getPlanStatus());
                progressMonitorCz.setAuditType(detailPlan.getAuditType());
                progressMonitorCz.setActivityType(detailPlan.getActivityTypeCode());
                progressMonitorCz.setActivityTypeName(detailPlan.getActivityTypeName());
                progressMonitorCz.setActivityForm(detailPlan.getActivityFormName());
                progressMonitorCz.setActivityBeginTime(detailPlan.getActivityBeginDate());
                progressMonitorCz.setActivityEndTime(detailPlan.getActivityEndDate());
                progressMonitorCz.setCustomerCode(detailPlan.getCustomerCode());
                progressMonitorCz.setCustomerName(detailPlan.getCustomerName());
                progressMonitorCz.setBrandCode(detailPlan.getProductBrandCode());
                progressMonitorCz.setBrandName(detailPlan.getProductBrandName());
                progressMonitorCz.setProductCode(detailPlan.getProductCode());
                progressMonitorCz.setProductName(detailPlan.getProductName());
                progressMonitorCz.setProductItemCode(detailPlan.getProductItemCode());
                progressMonitorCz.setProductItemName(detailPlan.getProductItemName());
                progressMonitorCz.setProductCategoryCode(detailPlan.getProductCategoryCode());
                progressMonitorCz.setProductCategoryName(detailPlan.getProductCategoryName());
                progressMonitorCz.setSystemCode(detailPlan.getSystemCode());
                progressMonitorCz.setSystemName(detailPlan.getSystemName());
                progressMonitorCz.setRegionCode(detailPlan.getRegion());
                progressMonitorCz.setRegionName(detailPlan.getRegionName());
                progressMonitorCz.setTerminalCode(detailPlan.getTerminalCode());
                progressMonitorCz.setTerminalName(detailPlan.getTerminalName());
                progressMonitorCz.setWriteOffMethod(detailPlan.getWriteOffMethod());
//                progressMonitorCz.setApplicationPromotionVolume(new BigDecimal(Optional.ofNullable(detailPlan.getPeriodPromotionalNumber()).orElse(0)));
//                progressMonitorCz.setApplicationFee(Optional.ofNullable(detailPlan.getTotalFeeAmount()).orElse(BigDecimal.ZERO));
                //申请数量在没有门店共用时，取期间促销件数；在有门店共用量时，取浮动量为申请数量
                if (BooleanEnum.FALSE.getCapital().equals(detailPlan.getPublicOrNot())){
                    progressMonitorCz.setApplicationPromotionVolume(new BigDecimal(Optional.ofNullable(detailPlan.getPeriodPromotionalNumber()).orElse(0)));

                }else {
                    progressMonitorCz.setApplicationPromotionVolume(detailPlan.getFloatingNumber());
                }
                //申请费用在没有门店共用时，取费用合计；在有门店共用量时，取浮动金额为申请金额
                if (BooleanEnum.FALSE.getCapital().equals(detailPlan.getPublicOrNot())){
                    progressMonitorCz.setApplicationFee(Optional.ofNullable(detailPlan.getTotalFeeAmount()).orElse(BigDecimal.ZERO));

                }else {
                    progressMonitorCz.setApplicationFee(Optional.ofNullable(detailPlan.getFloatingAmount()).orElse(BigDecimal.ZERO));
                }
                //KMS POS数据||门店、产品、日期
                dto.setDeliveryPartyCode(detailPlan.getTerminalCode());
                dto.setGoodsCode(detailPlan.getProductCode());
                dto.setSalesDateList(DateUtil.getBetweenDays(detailPlan.getActivityBeginDate(), detailPlan.getActivityEndDate()));
                BigDecimal kmsPosAmount = BigDecimal.ZERO;
                try {
                    kmsPosAmount = Optional.ofNullable(this.invoiceSalesDataVoService.findKmsPosQuantity(dto)).orElse(BigDecimal.ZERO);
                } catch (Exception e) {
                    log.error("=====>   促销进度监控表(垂直事后),获取KMS的POS数据失败[{}]   <=====", JSON.toJSONString(dto));
                    log.error("", e);
                }
                progressMonitorCz.setActualExecutionVolume(kmsPosAmount);
                //预计发生费用不去细案预测取，直接等于已发生促销量*单件申请费用
                progressMonitorCz.setEstimatedExpenseFee(kmsPosAmount.multiply(Optional.ofNullable(detailPlan.getSingleApplicationFee()).orElse(BigDecimal.ZERO)));

                progressMonitorCz.setRemainingSalesPromotion(Optional.ofNullable(progressMonitorCz.getApplicationPromotionVolume()).orElse(BigDecimal.ZERO).subtract(kmsPosAmount));
                progressMonitorCz.setSurplusActivityFee(progressMonitorCz.getApplicationFee().subtract(progressMonitorCz.getEstimatedExpenseFee()));
                if (BigDecimal.ZERO.compareTo(progressMonitorCz.getApplicationFee()) != 0) {
                    progressMonitorCz.setCostProgress(progressMonitorCz.getEstimatedExpenseFee().divide(progressMonitorCz.getApplicationFee(), 20, BigDecimal.ROUND_HALF_UP));
                } else {
                    progressMonitorCz.setCostProgress(BigDecimal.ZERO);
                }
                progressMonitorCz.setTenantCode(TenantUtils.getTenantCode());
                progressMonitorCz.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entityList.add(progressMonitorCz);
            });
            this.saveOrUpdateMonitorCz(entityList, null);

        } while (itemVoPage.hasNext());

    }

    /**
     * 每日更新数据（费用进度等信息）
     */
    @Override
    public void updateWithEveyDay() {
        //拉取SAP接口数据，计算费用进度等信息。
        return;
    }


}
