package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.constant.PromotionProgressConstant;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.service.PromotionProgressMonitorInService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.concurrent.TimeUnit;

/**
 * 促销进度规划报表 job
 *
 * @author cyj
 * @version 1.0
 * @date 2023/1/10 16:00
 * @description PromotionProgressMonitorXxlJob
 */
@Slf4j
@Service
public class PromotionProgressMonitorXxlJob {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private PromotionProgressMonitorInService promotionProgressMonitorInService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    /**
     * 促销进度监控表(垂直事中)
     */
    @DynamicTaskService(cornExpression = "0 0 3 * * ?", taskDesc = "促销进度监控表(垂直事中)")
    public void createOrUpdateDataCz() {
        loginUserService.refreshAuthentication(null);
        boolean lockSuccess = redisLockService.tryLock(PromotionProgressConstant.TPM_PROMOTION_PROGRESS_THINGS_LOCK, TimeUnit.HOURS, 6);
        Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
        try {
            promotionProgressMonitorInService.createOrUpdateDataCz(null, null);
        } finally {
            redisLockService.unlock(PromotionProgressConstant.TPM_PROMOTION_PROGRESS_THINGS_LOCK);
        }
    }

    /**
     * 促销进度监控表(垂直事后)
     */
    @DynamicTaskService(cornExpression = "0 30 3 * * ?", taskDesc = "促销进度监控表(垂直事后)")
    public void createOrUpdateDataCzAfter() {
        loginUserService.refreshAuthentication(null);
        boolean lockSuccess = redisLockService.tryLock(PromotionProgressConstant.TPM_PROMOTION_PROGRESS_AFTER_LOCK, TimeUnit.HOURS, 6);
        Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
        try {
            promotionProgressMonitorInService.createOrUpdateDataCzAfter(null, null);
        } finally {
            redisLockService.unlock(PromotionProgressConstant.TPM_PROMOTION_PROGRESS_AFTER_LOCK);
        }


    }
}
