package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.service.internal;

import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.repository.PromotionProgressMonitorCzRepository;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.dto.PromotionProgressCzWarningQueryDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningConditionDto;
import com.biz.crm.tpm.business.warning.config.sdk.dto.TpmWarningMonitoringVariable;
import com.biz.crm.tpm.business.warning.config.sdk.enums.TpmWarningDimensionEnum;
import com.biz.crm.tpm.business.warning.config.sdk.service.AbstractTpmWarningMonitoringVariableAndPushGroupRegister;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 垂直促销进度监控表-预警监控配置
 * @author wanghaojia
 * @date 2023/6/14 15:32
 */
@Service
public class WarningPromotionProgressMonitorRegisterAbstract extends AbstractTpmWarningMonitoringVariableAndPushGroupRegister {

    @Autowired(required = false)
    private PromotionProgressMonitorCzRepository promotionProgressMonitorCzRepository;

    public static final String monitoringTable = "tpm_promotion_progress_monitor_cz";


    @Override
    public String monitoringTable() {
        return monitoringTable;
    }

    @Override
    public List<TpmWarningMonitoringVariable> variableList() {
        List<TpmWarningMonitoringVariable> variableList = Lists.newArrayList();

//        当前日期、区域、零售商、门店、产品、实际退货（月累退货数量）、申请退转赠数量（申请数量）、实际退货金额（月累退货金额）、申请退货金额（申请金额）
        TpmWarningMonitoringVariable tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("now_date");
        tpmWarningMonitoringVariable.setVariableFieldName("当前日期");
        tpmWarningMonitoringVariable.setVariableQueryField("now_date");
        tpmWarningMonitoringVariable.setIsWaring(true);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("region_name");
        tpmWarningMonitoringVariable.setVariableFieldName("区域");
        tpmWarningMonitoringVariable.setVariableQueryField("region_name");
        tpmWarningMonitoringVariable.setIsWaring(true);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("system_name");
        tpmWarningMonitoringVariable.setVariableFieldName("零售商");
        tpmWarningMonitoringVariable.setVariableQueryField("system_name");
        tpmWarningMonitoringVariable.setIsWaring(true);
        variableList.add(tpmWarningMonitoringVariable);

//        促销申请费用（申请费用）、已消化费用（预计发生费用）、剩余费用
        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("application_fee");
        tpmWarningMonitoringVariable.setVariableFieldName("促销申请费用");
        tpmWarningMonitoringVariable.setVariableQueryField("application_fee");
        tpmWarningMonitoringVariable.setIsGroup(true);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("estimated_expense_fee");
        tpmWarningMonitoringVariable.setVariableFieldName("已消化费用");
        tpmWarningMonitoringVariable.setVariableQueryField("estimated_expense_fee");
        tpmWarningMonitoringVariable.setIsGroup(true);
        variableList.add(tpmWarningMonitoringVariable);


        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("surplus_activity_fee");
        tpmWarningMonitoringVariable.setVariableFieldName("剩余费用");
        tpmWarningMonitoringVariable.setVariableQueryField("surplus_activity_fee");
        tpmWarningMonitoringVariable.setIsGroup(true);
        variableList.add(tpmWarningMonitoringVariable);

        tpmWarningMonitoringVariable = new TpmWarningMonitoringVariable();
        tpmWarningMonitoringVariable.setVariableField("cost_progress");
        tpmWarningMonitoringVariable.setVariableFieldName("促销活动费用使用进度");
        tpmWarningMonitoringVariable.setVariableQueryField("cost_progress");
        variableList.add(tpmWarningMonitoringVariable);

        return variableList;
    }

    @Override
    public List<Map<String,Object>> dataList(List<TpmWarningConditionDto> conditionList) {
        PromotionProgressCzWarningQueryDto dto = new PromotionProgressCzWarningQueryDto();
        String appendWhereSql = super.appendWhereSql(conditionList);
        dto.setAppendWhereSql(appendWhereSql);
        List<Map<String, Object>> list = promotionProgressMonitorCzRepository.findPromotionProgressMonitorCzWarning(dto);
        String nowDate = DateUtil.getDateStrByFormat(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        for (Map<String, Object> objectMap : list) {
            objectMap.put("now_date",nowDate);
        }
        return list;
    }

    @Override
    public String businessCodeField() {
        return "id";
    }

    @Override
    public String getDimensionCodeKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return "region_code";
            case SYSTEM:
                return "system_code";
        }
        return null;
    }

    @Override
    public List<String> defaultDimensionKey() {
        return com.google.common.collect.Lists.newArrayList("now_date");
    }

    @Override
    public List<String> getDimensionKey(TpmWarningDimensionEnum dimension) {
        switch (dimension){
            case REGION:
                return com.google.common.collect.Lists.newArrayList("region_code","region_name");
            case SYSTEM:
                return com.google.common.collect.Lists.newArrayList("system_code","system_name");
        }
        return org.apache.commons.compress.utils.Lists.newArrayList();
    }

}
