/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.dto.PromotionProgressMonitorInDto;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.service.PromotionProgressMonitorInService;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.vo.PromotionProgressMonitorInVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/promotionProgressMonitorIn"})
@Api(tags={"\u4fc3\u9500\u8fdb\u5ea6\u76d1\u63a7\u8868\uff08\u4e8b\u4e2d\uff09"})
public class PromotionProgressMonitorInController {
    private static final Logger log = LoggerFactory.getLogger(PromotionProgressMonitorInController.class);
    @Autowired(required=false)
    private PromotionProgressMonitorInService progressMonitorInService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<PromotionProgressMonitorInVO>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=20) Pageable pageable, @ApiParam(name="promotionProgressMonitor", value="\u4fc3\u9500\u8fdb\u5ea6\u76d1\u63a7\u8868(\u4e8b\u4e2d)") PromotionProgressMonitorInDto promotionProgressMonitor) {
        try {
            Page page = this.progressMonitorInService.findByConditions(pageable, promotionProgressMonitor);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952eid\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"/findById"})
    public Result<PromotionProgressMonitorInVO> findById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            PromotionProgressMonitorInVO progressMonitorInVO = this.progressMonitorInService.findById(id);
            return Result.ok((Object)progressMonitorInVO);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u3001\u66f4\u65b0")
    @PostMapping(value={"/createOrUpdateItemData"})
    public Result<?> createOrUpdateItemData(@RequestParam(value="codes") @ApiParam(name="codes", value="codes") List<String> codes) {
        try {
            this.progressMonitorInService.createOrUpdateData(codes);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u589e\u3001\u66f4\u65b0")
    @PostMapping(value={"/createOrUpdateDataCz"})
    public Result<?> createOrUpdateDataCz(@RequestParam(value="codes", required=false) @ApiParam(name="codes", value="codes") List<String> codes, @RequestParam(value="date", required=false) @ApiParam(name="date", value="date") String date) {
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("TPM:PROMOTION_PROGRESS:THINGS_LOCK", TimeUnit.HOURS, 6L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.progressMonitorInService.createOrUpdateDataCz(codes, date);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("TPM:PROMOTION_PROGRESS:THINGS_LOCK");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u589e\u3001\u66f4\u65b0")
    @PostMapping(value={"/createOrUpdateDataCzAfter"})
    public Result<?> createOrUpdateDataCzAfter(@RequestParam(value="codes", required=false) @ApiParam(name="codes", value="codes") List<String> codes, @RequestParam(value="date", required=false) @ApiParam(name="date", value="date") String date) {
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("TPM:PROMOTION_PROGRESS:AFTER_LOCK", TimeUnit.HOURS, 6L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.progressMonitorInService.createOrUpdateDataCzAfter(codes, date);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("TPM:PROMOTION_PROGRESS:AFTER_LOCK");
            }
        }
    }

    @ApiOperation(value="\u6bcf\u65e5\u66f4\u65b0\u6570\u636e", httpMethod="POST")
    @PostMapping(value={"/updateWithEveyDay"})
    public void updateWithEveyDay() {
        try {
            this.progressMonitorInService.updateWithEveyDay();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

