/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.promotion.progress.monitor.in.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.kms.business.invoice.sales.data.sdk.dto.SalesDataDto;
import com.biz.crm.kms.business.invoice.sales.data.sdk.service.InvoiceSalesDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.WriteOffMethodEnum;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.entity.PromotionProgressMonitorCz;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.entity.PromotionProgressMonitorIn;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.repository.PromotionProgressMonitorCzRepository;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.local.repository.PromotionProgressMonitorInRepository;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.dto.PromotionProgressMonitorInDto;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.service.PromotionProgressMonitorInService;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.vo.PromotionProgressMonitorInVO;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PromotionProgressMonitorServiceInImpl
implements PromotionProgressMonitorInService {
    private static final Logger log = LoggerFactory.getLogger(PromotionProgressMonitorServiceInImpl.class);
    private final String SAP = "SAP";
    @Autowired(required=false)
    private PromotionProgressMonitorInRepository promotionProgressMonitorInRepository;
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private PromotionProgressMonitorCzRepository promotionProgressMonitorCzRepository;
    @Autowired(required=false)
    private InvoiceSalesDataVoService invoiceSalesDataVoService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public Page<PromotionProgressMonitorInVO> findByConditions(Pageable pageable, PromotionProgressMonitorInDto promotionProgressMonitorIn) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)20);
        }
        if (promotionProgressMonitorIn == null) {
            promotionProgressMonitorIn = new PromotionProgressMonitorInDto();
        }
        return this.promotionProgressMonitorInRepository.findByConditions(pageable, promotionProgressMonitorIn);
    }

    public PromotionProgressMonitorInVO findById(String id) {
        if (!StringUtils.isBlank((CharSequence)id)) {
            PromotionProgressMonitorIn progressMonitorIn = (PromotionProgressMonitorIn)((Object)this.promotionProgressMonitorInRepository.getById((Serializable)((Object)id)));
            return (PromotionProgressMonitorInVO)this.nebulaToolkitService.copyObjectByWhiteList((Object)progressMonitorIn, PromotionProgressMonitorInVO.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void createOrUpdateData(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        ArrayList entityList = new ArrayList();
        List detailPlanList = this.subComActivityDetailPlanVoService.findDetailPlanAndItemByPlanCode(codes);
        detailPlanList.forEach(detailPlan -> {
            if (!CollectionUtils.isEmpty((Collection)detailPlan.getItemList())) {
                List detailPlanItemList = detailPlan.getItemList();
                Set detailPlanItemCodes = detailPlanItemList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
                List byActivityDetailItemCode = this.detailedForecastService.findByActivityDetailItemCode(detailPlanItemCodes);
                Map<String, BigDecimal> estimatedExpenseFeeMap = byActivityDetailItemCode.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, DetailedForecastVo::getEstimatedWriteOffAmount));
                detailPlanItemList.forEach(detailPlanItemVo -> {
                    PromotionProgressMonitorIn progressMonitorIn = new PromotionProgressMonitorIn();
                    progressMonitorIn.setId(detailPlanItemVo.getConstituentDetailPlanItemCode());
                    progressMonitorIn.setFeeYearMonth(detailPlanItemVo.getFeeYearMonth());
                    progressMonitorIn.setBusinessFormatCode(detailPlan.getBusinessFormatCode());
                    progressMonitorIn.setOrgCode(detailPlan.getOrgCode());
                    progressMonitorIn.setOrgName(detailPlan.getOrgName());
                    progressMonitorIn.setSalesOrgCode(detailPlan.getSalesOrgCode());
                    progressMonitorIn.setSalesOrgName(detailPlan.getSalesOrgName());
                    progressMonitorIn.setActivityDetailPlanCode(detailPlanItemVo.getConstituentDetailPlanCode());
                    progressMonitorIn.setActivityDetailPlanName(detailPlanItemVo.getConstituentDetailPlanName());
                    progressMonitorIn.setActivityDetailCode(detailPlanItemVo.getConstituentDetailPlanItemCode());
                    progressMonitorIn.setActivityStatus(detailPlanItemVo.getActivityStatus());
                    progressMonitorIn.setAuditType(detailPlanItemVo.getAuditType());
                    progressMonitorIn.setActivityType(detailPlanItemVo.getActivityType());
                    progressMonitorIn.setActivityForm(detailPlanItemVo.getActivityFormName());
                    progressMonitorIn.setActivityBeginTime(detailPlanItemVo.getActivityBeginTime());
                    progressMonitorIn.setActivityEndTime(detailPlanItemVo.getActivityEndTime());
                    progressMonitorIn.setCustomerCode(detailPlanItemVo.getCustomerCode());
                    progressMonitorIn.setCustomerName(detailPlanItemVo.getCustomerName());
                    progressMonitorIn.setBrandCode(detailPlanItemVo.getProductBrandCode());
                    progressMonitorIn.setBrandName(detailPlanItemVo.getProductBrandName());
                    progressMonitorIn.setProductItemCode(detailPlanItemVo.getProductItemCode());
                    progressMonitorIn.setProductItemName(detailPlanItemVo.getProductItemName());
                    progressMonitorIn.setProductCategoryCode(detailPlanItemVo.getProductCategoryCode());
                    progressMonitorIn.setProductCategoryName(detailPlanItemVo.getProductCategoryName());
                    String promoteSales = detailPlanItemVo.getPromoteSales().toString();
                    progressMonitorIn.setApplicationPromotionVolume(Integer.parseInt(promoteSales.substring(0, promoteSales.indexOf("."))));
                    progressMonitorIn.setApplicationFee(detailPlanItemVo.getTotalCost());
                    BigDecimal estimatedExpenseFee = (BigDecimal)estimatedExpenseFeeMap.get(detailPlanItemVo.getConstituentDetailPlanItemCode());
                    progressMonitorIn.setEstimatedExpenseFee(estimatedExpenseFee);
                    progressMonitorIn.setSurplusActivityFee(detailPlanItemVo.getTotalCost().subtract(estimatedExpenseFee));
                    progressMonitorIn.setCostProgress(estimatedExpenseFee.divide(detailPlanItemVo.getTotalCost(), 20, 4));
                    progressMonitorIn.setTenantCode(TenantUtils.getTenantCode());
                    progressMonitorIn.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    entityList.add(progressMonitorIn);
                });
            }
        });
        this.promotionProgressMonitorInRepository.saveOrUpdateBatch(entityList);
    }

    public void createOrUpdateDataCz(List<String> codes, String date) {
        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        if (!CollectionUtils.isEmpty(codes)) {
            activityDetailPlanItemDto.setDetailPlanItemCodeList(codes);
        }
        List planItemVoList = new ArrayList();
        PageRequest pageRequest = PageRequest.of((int)1, (int)200);
        activityDetailPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activityDetailPlanItemDto.setTenantCode(TenantUtils.getTenantCode());
        activityDetailPlanItemDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        if (StringUtils.isNotEmpty((CharSequence)date)) {
            activityDetailPlanItemDto.setNowTime(date);
        } else {
            activityDetailPlanItemDto.setNowTime(DateUtil.dateStrNowYYYYMMDD());
        }
        activityDetailPlanItemDto.setWriteOffMethod(WriteOffMethodEnum.THINGS.getCode());
        activityDetailPlanItemDto.setTypeCodes(Stream.of("Z0006", "Z0048", "Z0021").collect(Collectors.toList()));
        Page itemVoPage = null;
        ArrayList<PromotionProgressMonitorCz> entityList = new ArrayList<PromotionProgressMonitorCz>();
        do {
            itemVoPage = this.activityDetailPlanItemSdkService.findByConditions((Pageable)pageRequest, activityDetailPlanItemDto);
            log.info("\u4fc3\u9500\u8fdb\u5ea6\u76d1\u63a7\u8868(\u5782\u76f4\u4e8b\u4e2d)\u67e5\u8be2[{}/{}]", (Object)itemVoPage.getCurrent(), (Object)itemVoPage.getPages());
            pageRequest = pageRequest.next();
            planItemVoList = itemVoPage.getRecords();
            if (CollectionUtils.isEmpty(planItemVoList)) {
                return;
            }
            Set detailPlanItemCodes = planItemVoList.stream().map(ActivityDetailPlanItemBase::getDetailPlanItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List byActivityDetailItemCodes = this.activityDetailPlanItemSdkService.findByActivityDetailItemCodes(detailPlanItemCodes);
            List byActivityDetailItemCode = this.detailedForecastService.findByActivityDetailItemCode(detailPlanItemCodes);
            Map<String, BigDecimal> estimatedExpenseFeeMap = byActivityDetailItemCode.stream().filter(item -> Objects.nonNull(item.getEstimatedWriteOffAmount())).collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, DetailedForecastVo::getEstimatedWriteOffAmount, (n, o) -> n));
            List auditExecuteIndicatorList = Optional.ofNullable(this.auditExecuteIndicatorService.findByActiveNumber(detailPlanItemCodes.stream().collect(Collectors.toList()), "SAP", BusinessUnitEnum.VERTICAL.getCode())).orElse(new ArrayList());
            Map<String, List<AuditExecuteIndicatorVo>> auditExecuteIndicatorMap = auditExecuteIndicatorList.stream().collect(Collectors.groupingBy(AuditExecuteIndicatorVo::getActiveNumber));
            entityList.clear();
            planItemVoList.forEach(detailPlan -> {
                PromotionProgressMonitorCz progressMonitorCz = new PromotionProgressMonitorCz();
                progressMonitorCz.setId(detailPlan.getDetailPlanItemCode());
                progressMonitorCz.setFeeYearMonth(detailPlan.getFeeYearMonth());
                progressMonitorCz.setBusinessFormatCode(detailPlan.getBusinessFormatCode());
                progressMonitorCz.setBusinessUnitCode(detailPlan.getBusinessUnitCode());
                progressMonitorCz.setTerminalCode(detailPlan.getTerminalCode());
                progressMonitorCz.setTerminalName(detailPlan.getTerminalName());
                progressMonitorCz.setSalesInstitutionCode(detailPlan.getActivityOrgCode());
                progressMonitorCz.setSalesInstitutionName(detailPlan.getActivityOrgName());
                progressMonitorCz.setActivityDetailCode(detailPlan.getDetailPlanCode());
                progressMonitorCz.setActivityDetailName(detailPlan.getDetailPlanName());
                progressMonitorCz.setActivityDetailItemCode(detailPlan.getDetailPlanItemCode());
                progressMonitorCz.setActivityStatus(detailPlan.getPlanStatus());
                progressMonitorCz.setAuditType(detailPlan.getAuditType());
                progressMonitorCz.setActivityType(detailPlan.getActivityTypeCode());
                progressMonitorCz.setActivityTypeName(detailPlan.getActivityTypeName());
                progressMonitorCz.setActivityForm(detailPlan.getActivityFormName());
                progressMonitorCz.setActivityBeginTime(detailPlan.getActivityBeginDate());
                progressMonitorCz.setActivityEndTime(detailPlan.getActivityEndDate());
                progressMonitorCz.setCustomerCode(detailPlan.getCustomerCode());
                progressMonitorCz.setCustomerName(detailPlan.getCustomerName());
                progressMonitorCz.setBrandCode(detailPlan.getProductBrandCode());
                progressMonitorCz.setBrandName(detailPlan.getProductBrandName());
                progressMonitorCz.setProductItemCode(detailPlan.getProductItemCode());
                progressMonitorCz.setProductItemName(detailPlan.getProductItemName());
                progressMonitorCz.setProductCode(detailPlan.getProductCode());
                progressMonitorCz.setProductName(detailPlan.getProductName());
                progressMonitorCz.setProductCategoryCode(detailPlan.getProductCategoryCode());
                progressMonitorCz.setProductCategoryName(detailPlan.getProductCategoryName());
                progressMonitorCz.setSystemCode(detailPlan.getSystemCode());
                progressMonitorCz.setSystemName(detailPlan.getSystemName());
                progressMonitorCz.setRegionCode(detailPlan.getRegion());
                progressMonitorCz.setRegionName(detailPlan.getRegionName());
                progressMonitorCz.setWriteOffMethod(detailPlan.getWriteOffMethod());
                if (BooleanEnum.FALSE.getCapital().equals(detailPlan.getPublicOrNot())) {
                    progressMonitorCz.setApplicationPromotionVolume(new BigDecimal(Optional.ofNullable(detailPlan.getPeriodPromotionalNumber()).orElse(0)));
                } else {
                    progressMonitorCz.setApplicationPromotionVolume(Optional.ofNullable(detailPlan.getFloatingNumber()).orElse(BigDecimal.ZERO));
                }
                if (BooleanEnum.FALSE.getCapital().equals(detailPlan.getPublicOrNot())) {
                    progressMonitorCz.setApplicationFee(Optional.ofNullable(detailPlan.getTotalFeeAmount()).orElse(BigDecimal.ZERO));
                } else {
                    progressMonitorCz.setApplicationFee(Optional.ofNullable(detailPlan.getFloatingAmount()).orElse(BigDecimal.ZERO));
                }
                BigDecimal estimatedExpenseFee = (BigDecimal)estimatedExpenseFeeMap.get(detailPlan.getDetailPlanItemCode());
                List auditExecuteIndicatorVos = (List)auditExecuteIndicatorMap.get(detailPlan.getDetailPlanItemCode());
                BigDecimal actualExecutionVolume = BigDecimal.ZERO;
                if (!CollectionUtils.isEmpty((Collection)auditExecuteIndicatorVos)) {
                    BigDecimal bigDecimal = Optional.of(auditExecuteIndicatorVos.stream().filter(item -> IndicatorNameEnum.SAP_QUANTITY.getCode().equals(item.getIndicatorName())).map(AuditExecuteIndicatorVo::getIndicatorValue).filter(Objects::nonNull).reduce(BigDecimal::add).get()).orElse(BigDecimal.ZERO);
                    actualExecutionVolume = actualExecutionVolume.add(bigDecimal);
                }
                progressMonitorCz.setEstimatedExpenseFee(Optional.ofNullable(estimatedExpenseFee).orElse(BigDecimal.ZERO));
                progressMonitorCz.setActualExecutionVolume(Optional.ofNullable(actualExecutionVolume).orElse(BigDecimal.ZERO));
                if (!CollectionUtils.isEmpty((Collection)byActivityDetailItemCodes)) {
                    Map<String, BigDecimal> collect = byActivityDetailItemCodes.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, item -> Optional.ofNullable(item.getOriginalPriceGift()).orElse(BigDecimal.ZERO)));
                    progressMonitorCz.setEstimatedExpenseFee(Optional.ofNullable(collect.get(detailPlan.getDetailPlanItemCode())).orElse(BigDecimal.ZERO).multiply(progressMonitorCz.getActualExecutionVolume()));
                }
                progressMonitorCz.setApplicationPromotionVolume(Optional.ofNullable(progressMonitorCz.getApplicationPromotionVolume()).orElse(BigDecimal.ZERO));
                progressMonitorCz.setRemainingSalesPromotion(progressMonitorCz.getApplicationPromotionVolume().subtract(progressMonitorCz.getActualExecutionVolume()));
                progressMonitorCz.setSurplusActivityFee(progressMonitorCz.getApplicationFee().subtract(Optional.ofNullable(estimatedExpenseFee).orElse(BigDecimal.ZERO)));
                if (BigDecimal.ZERO.compareTo(progressMonitorCz.getApplicationFee()) != 0) {
                    progressMonitorCz.setCostProgress(progressMonitorCz.getEstimatedExpenseFee().divide(progressMonitorCz.getApplicationFee(), 20, 4));
                } else {
                    progressMonitorCz.setCostProgress(BigDecimal.ZERO);
                }
                if (BigDecimal.ZERO.compareTo(progressMonitorCz.getCostProgress()) <= 0) {
                    progressMonitorCz.setWarnType("\u9884\u8b66");
                } else {
                    progressMonitorCz.setWarnType("\u6b63\u5e38");
                }
                progressMonitorCz.setTenantCode(TenantUtils.getTenantCode());
                progressMonitorCz.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entityList.add(progressMonitorCz);
            });
            this.saveOrUpdateMonitorCz(entityList, null);
        } while (itemVoPage.hasNext());
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateMonitorCz(List<PromotionProgressMonitorCz> entityList, List<String> idList) {
        if (CollectionUtil.isNotEmpty(entityList)) {
            this.promotionProgressMonitorCzRepository.saveOrUpdateBatch(entityList);
        }
    }

    public void createOrUpdateDataCzAfter(List<String> codes, String date) {
        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
        if (!CollectionUtils.isEmpty(codes)) {
            activityDetailPlanItemDto.setDetailPlanItemCodeList(codes);
        }
        List planItemVoList = new ArrayList();
        PageRequest pageRequest = PageRequest.of((int)1, (int)200);
        activityDetailPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activityDetailPlanItemDto.setTenantCode(TenantUtils.getTenantCode());
        activityDetailPlanItemDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        activityDetailPlanItemDto.setWriteOffMethod(WriteOffMethodEnum.AFTER_THE_EVENT.getCode());
        if (StringUtils.isNotEmpty((CharSequence)date)) {
            activityDetailPlanItemDto.setNowTime(date);
        } else {
            activityDetailPlanItemDto.setNowTime(DateUtil.dateStrNowYYYYMMDD());
        }
        activityDetailPlanItemDto.setTypeCodes(Stream.of("Z0006", "Z0048", "Z0021").collect(Collectors.toList()));
        Page itemVoPage = null;
        ArrayList<PromotionProgressMonitorCz> entityList = new ArrayList<PromotionProgressMonitorCz>();
        do {
            itemVoPage = this.activityDetailPlanItemSdkService.findByConditions((Pageable)pageRequest, activityDetailPlanItemDto);
            log.info("\u4fc3\u9500\u8fdb\u5ea6\u76d1\u63a7\u8868(\u5782\u76f4\u4e8b\u540e)\u67e5\u8be2[{}/{}]", (Object)itemVoPage.getCurrent(), (Object)itemVoPage.getPages());
            pageRequest = pageRequest.next();
            planItemVoList = itemVoPage.getRecords();
            if (CollectionUtils.isEmpty(planItemVoList)) {
                return;
            }
            SalesDataDto dto = new SalesDataDto();
            entityList.clear();
            planItemVoList.forEach(detailPlan -> {
                PromotionProgressMonitorCz progressMonitorCz = new PromotionProgressMonitorCz();
                progressMonitorCz.setId(detailPlan.getDetailPlanItemCode());
                progressMonitorCz.setFeeYearMonth(detailPlan.getFeeYearMonth());
                progressMonitorCz.setBusinessFormatCode(detailPlan.getBusinessFormatCode());
                progressMonitorCz.setBusinessUnitCode(detailPlan.getBusinessUnitCode());
                progressMonitorCz.setSalesInstitutionCode(detailPlan.getActivityOrgCode());
                progressMonitorCz.setSalesInstitutionName(detailPlan.getActivityOrgName());
                progressMonitorCz.setActivityDetailCode(detailPlan.getDetailPlanCode());
                progressMonitorCz.setActivityDetailName(detailPlan.getDetailPlanName());
                progressMonitorCz.setActivityDetailItemCode(detailPlan.getDetailPlanItemCode());
                progressMonitorCz.setActivityStatus(detailPlan.getPlanStatus());
                progressMonitorCz.setAuditType(detailPlan.getAuditType());
                progressMonitorCz.setActivityType(detailPlan.getActivityTypeCode());
                progressMonitorCz.setActivityTypeName(detailPlan.getActivityTypeName());
                progressMonitorCz.setActivityForm(detailPlan.getActivityFormName());
                progressMonitorCz.setActivityBeginTime(detailPlan.getActivityBeginDate());
                progressMonitorCz.setActivityEndTime(detailPlan.getActivityEndDate());
                progressMonitorCz.setCustomerCode(detailPlan.getCustomerCode());
                progressMonitorCz.setCustomerName(detailPlan.getCustomerName());
                progressMonitorCz.setBrandCode(detailPlan.getProductBrandCode());
                progressMonitorCz.setBrandName(detailPlan.getProductBrandName());
                progressMonitorCz.setProductCode(detailPlan.getProductCode());
                progressMonitorCz.setProductName(detailPlan.getProductName());
                progressMonitorCz.setProductItemCode(detailPlan.getProductItemCode());
                progressMonitorCz.setProductItemName(detailPlan.getProductItemName());
                progressMonitorCz.setProductCategoryCode(detailPlan.getProductCategoryCode());
                progressMonitorCz.setProductCategoryName(detailPlan.getProductCategoryName());
                progressMonitorCz.setSystemCode(detailPlan.getSystemCode());
                progressMonitorCz.setSystemName(detailPlan.getSystemName());
                progressMonitorCz.setRegionCode(detailPlan.getRegion());
                progressMonitorCz.setRegionName(detailPlan.getRegionName());
                progressMonitorCz.setTerminalCode(detailPlan.getTerminalCode());
                progressMonitorCz.setTerminalName(detailPlan.getTerminalName());
                progressMonitorCz.setWriteOffMethod(detailPlan.getWriteOffMethod());
                if (BooleanEnum.FALSE.getCapital().equals(detailPlan.getPublicOrNot())) {
                    progressMonitorCz.setApplicationPromotionVolume(new BigDecimal(Optional.ofNullable(detailPlan.getPeriodPromotionalNumber()).orElse(0)));
                } else {
                    progressMonitorCz.setApplicationPromotionVolume(detailPlan.getFloatingNumber());
                }
                if (BooleanEnum.FALSE.getCapital().equals(detailPlan.getPublicOrNot())) {
                    progressMonitorCz.setApplicationFee(Optional.ofNullable(detailPlan.getTotalFeeAmount()).orElse(BigDecimal.ZERO));
                } else {
                    progressMonitorCz.setApplicationFee(Optional.ofNullable(detailPlan.getFloatingAmount()).orElse(BigDecimal.ZERO));
                }
                dto.setDeliveryPartyCode(detailPlan.getTerminalCode());
                dto.setGoodsCode(detailPlan.getProductCode());
                dto.setSalesDateList(DateUtil.getBetweenDays((Date)detailPlan.getActivityBeginDate(), (Date)detailPlan.getActivityEndDate()));
                BigDecimal kmsPosAmount = BigDecimal.ZERO;
                try {
                    kmsPosAmount = Optional.ofNullable(this.invoiceSalesDataVoService.findKmsPosQuantity(dto)).orElse(BigDecimal.ZERO);
                }
                catch (Exception e) {
                    log.error("=====>   \u4fc3\u9500\u8fdb\u5ea6\u76d1\u63a7\u8868(\u5782\u76f4\u4e8b\u540e),\u83b7\u53d6KMS\u7684POS\u6570\u636e\u5931\u8d25[{}]   <=====", (Object)JSON.toJSONString((Object)dto));
                    log.error("", (Throwable)e);
                }
                progressMonitorCz.setActualExecutionVolume(kmsPosAmount);
                progressMonitorCz.setEstimatedExpenseFee(kmsPosAmount.multiply(Optional.ofNullable(detailPlan.getSingleApplicationFee()).orElse(BigDecimal.ZERO)));
                progressMonitorCz.setRemainingSalesPromotion(Optional.ofNullable(progressMonitorCz.getApplicationPromotionVolume()).orElse(BigDecimal.ZERO).subtract(kmsPosAmount));
                progressMonitorCz.setSurplusActivityFee(progressMonitorCz.getApplicationFee().subtract(progressMonitorCz.getEstimatedExpenseFee()));
                if (BigDecimal.ZERO.compareTo(progressMonitorCz.getApplicationFee()) != 0) {
                    progressMonitorCz.setCostProgress(progressMonitorCz.getEstimatedExpenseFee().divide(progressMonitorCz.getApplicationFee(), 20, 4));
                } else {
                    progressMonitorCz.setCostProgress(BigDecimal.ZERO);
                }
                progressMonitorCz.setTenantCode(TenantUtils.getTenantCode());
                progressMonitorCz.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                entityList.add(progressMonitorCz);
            });
            this.saveOrUpdateMonitorCz(entityList, null);
        } while (itemVoPage.hasNext());
    }

    public void updateWithEveyDay() {
    }
}

