package com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.dto.PromotionProgressMonitorInDto;
import com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.vo.PromotionProgressMonitorInVO;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 *
 * @author : qiancheng
 * @date : 2022-11-18
 */
public interface PromotionProgressMonitorInService {

    /**
     * 分页查询数据
     * @param pageable        分页对象
     * @param promotionProgressMonitor 实体对象
     * @return 分页对象
     */
    Page<PromotionProgressMonitorInVO> findByConditions(Pageable pageable, PromotionProgressMonitorInDto promotionProgressMonitor);

    /**
     * 通过主键id 查单条数据
     * @param id 主键id
     * @return 单条数据
     */
    PromotionProgressMonitorInVO findById(String id);

    /**
     * 新赠/更新数据（审批通过的分子公司细案）
     * @param codes 分子公司细案编码
     */
    void createOrUpdateData(List<String> codes);

    /**
     * 新赠/更新数据（审批通过的垂直细案事中）
     */
    void createOrUpdateDataCz(List<String> codes,String date);

    /**
     * 新赠/更新数据（审批通过的垂直细案事后）
     */
    void createOrUpdateDataCzAfter(List<String> codes,String date);

    /**
     * 每日更新数据（费用进度等信息）
     */
    void updateWithEveyDay();

}
