package com.biz.crm.tpm.business.promotion.progress.monitor.in.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author : qiancheng
 * @date : 2022-11-3
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PromotionProgressMonitorInVO", description = "促销进度监控表（事中）vo")
public class PromotionProgressMonitorInVO extends TenantFlagOpVo {

    @ApiModelProperty(name = "feeYearMonth",value = "费用所属年月",notes = "费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    @ApiModelProperty(name = "businessFormatCode",value = "业态编码",notes = "业态编码")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "orgCode",value = "组织编码",notes = "组织编码")
    private String orgCode;

    @ApiModelProperty(name = "orgName",value = "组织名称",notes = "组织名称")
    private String orgName;

    @ApiModelProperty(name = "salesOrgCode",value = "销售部门编码",notes = "销售部门编码")
    private String salesOrgCode;

    @ApiModelProperty(name = "salesOrgName",value = "销售部门名称",notes = "销售部门名称")
    private String salesOrgName;

    @ApiModelProperty(name = "activityDetailPlanCode",value = "活动细案编码",notes = "活动细案编码")
    private String activityDetailPlanCode;

    @ApiModelProperty(name = "activityDetailPlanName",value = "活动细案名称",notes = "活动细案名称")
    private String activityDetailPlanName;

    @ApiModelProperty(name = "activityDetailCode",value = "活动明细编码",notes = "活动明细编码")
    private String activityDetailCode;

    @ApiModelProperty(name = "activityStatus",value = "活动状态",notes = "活动状态")
    private String activityStatus;

    @ApiModelProperty(name = "auditType",value = "核销方式",notes = "核销方式")
    private String auditType;

    @ApiModelProperty(name = "activityType",value = "活动类型",notes = "活动类型")
    private String activityType;

    @ApiModelProperty(name = "activityForm",value = "活动形式",notes = "活动形式")
    private String activityForm;

    @ApiModelProperty(name = "activityBeginTime",value = "活动开始时间",notes = "活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginTime;

    @ApiModelProperty(name = "activityEndTime",value = "活动结束时间",notes = "活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndTime;

    @ApiModelProperty(name = "system",value = "系统",notes = "系统")
    private String system;

    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerCode",value = "客户名称",notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "brandCode",value = "品牌编码",notes = "品牌编码")
    private String brandCode;

    @ApiModelProperty(name = "brandName",value = "品牌名称",notes = "品牌名称")
    private String brandName;

    @ApiModelProperty(name = "productItemCode",value = "产品品项编码",notes = "产品品项编码")
    private String productItemCode;

    @ApiModelProperty(name = "productItemName",value = "产品品项名称",notes = "产品品项名称")
    private String productItemName;

    @ApiModelProperty(name = "productCategoryCode",value = "产品品类编码",notes = "产品品类编码")
    private String productCategoryCode;

    @ApiModelProperty(name = "productCategoryName",value = "产品品类名称",notes = "产品品类名称")
    private String productCategoryName;

    @ApiModelProperty(name = "promotionRule",value = "促销规则",notes = "促销规则")
    private String promotionRule;

    @ApiModelProperty(name = "applicationPromotionVolume",value = "申请促销量",notes = "申请促销量")
    private Integer applicationPromotionVolume;

    @ApiModelProperty(name = "applicationFee",value = "申请金额",notes = "申请金额")
    private BigDecimal applicationFee;

    @ApiModelProperty(name = "estimatedExpenseFee",value = "预计发生费用",notes = "预计发生费用")
    private BigDecimal estimatedExpenseFee;

    @ApiModelProperty(name = "surplusActivityFee",value = "活动剩余费用",notes = "活动剩余费用")
    private BigDecimal surplusActivityFee;

    @ApiModelProperty(name = "costProgress",value = "费用进度",notes = "费用进度")
    private BigDecimal costProgress;

    @ApiModelProperty(name = "timeSchedule",value = "时间进度",notes = "时间进度")
    private Long timeSchedule;

    @ApiModelProperty(name = "actualExecutionVolume",value = "已发生促销量",notes = "实际执行量")
    private Integer actualExecutionVolume;

    @ApiModelProperty(name = "surplusPromotionVolume",value = "剩余促销量",notes = "剩余促销量")
    private Integer surplusPromotionVolume;

    @ApiModelProperty(name = "executionProgress",value = "执行进度",notes = "执行进度")
    private Integer executionProgress;



}
