package com.biz.crm.tpm.business.reconciliation.doc.list.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.service.ReconciliationDocBuildService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationDocListService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.controller.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author xiaoyoujun
 * @date 2022年11月17日 11:02
 */
@RestController
@RequestMapping("/v1/reconciliation/docList")
@Slf4j
@Api(tags = "对账单据列表")
public class ReconciliationDocListController extends BaseController {
    /**
     * 服务对象
     */
    @Autowired(required = false)
    private ReconciliationDocListService reconciliationDocListService;

    @Autowired(required = false)
    private ReconciliationDocBuildService reconciliationDocBuildService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;


    /**
     * 分页查询所有数据
     *
     * @param pageable                 分页对象
     * @param reconciliationDocListDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByReconciliations")
    public Result<Page<ReconciliationDocListVo>> findByReconciliations(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                       @ApiParam(name = "reconciliationDocListDto", value = "对账单据列表") ReconciliationDocListDto reconciliationDocListDto) {
        try {
            Page<ReconciliationDocListVo> page = this.reconciliationDocListService.findByReconciliations(pageable, reconciliationDocListDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询所有数据
     *
     * @param pageable                 分页对象
     * @param reconciliationDocListDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findPageForOut")
    public Result<Page<ReconciliationDocListVo>> findPageForOut(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                ReconciliationDocListDto reconciliationDocListDto) {
        try {
            Page<ReconciliationDocListVo> page = this.reconciliationDocListService.findPageForOut(pageable, reconciliationDocListDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 更新对账单(重新生成对账单)
     *
     * @param ids id
     * @return {@link Result}<{@link ?}>
     */
    @ApiOperation(value = "更新对账单(重新生成对账单)")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "ids", value = "主键列表") @RequestBody List<String> ids) {
        try {
            this.reconciliationDocListService.regenerate(ids);
            return Result.ok("");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("{id}")
    public Result<ReconciliationDocListVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id", required = true) String id) {
        try {
            ReconciliationDocListVo eventPrepaymentVo = this.reconciliationDocListService.findById(id);
            return Result.ok(eventPrepaymentVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 推送电子签章
     *
     * @param ids 数据主键列表
     * @return 结果
     */
    @ApiOperation(value = "推送电子签章")
    @PostMapping("contract")
    public Result<?> pushAccountCheckBill(@ApiParam(name = "ids", value = "主键列表") @RequestBody List<String> ids) {
        try {
            //todo
            this.reconciliationDocListService.pushAccountCheckBill(ids);
            return Result.ok("操作成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 作废电子签章
     *
     * @param ids 数据主键列表
     * @return 结果
     */
    @ApiOperation(value = "作废")
    @PostMapping("cancel")
    public Result<?> cancellationContract(@ApiParam(name = "ids", value = "主键列表") @RequestBody List<String> ids) {
        try {
            this.reconciliationDocListService.cancellationContract(ids);
            return Result.ok("操作成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 撤回电子签章
     *
     * @param ids 数据主键列表
     * @return 结果
     */
    @ApiOperation(value = "撤回")
    @PostMapping("recall")
    public Result<?> withdrawalContract(@ApiParam(name = "ids", value = "主键列表") @RequestBody List<String> ids) {
        try {
            this.reconciliationDocListService.withdrawalContract(ids);
            return Result.ok("操作成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 查看电子签章
     *
     * @param ids 数据主键列表
     * @return 结果
     */
    @ApiOperation(value = "查看")
    @PostMapping("viewurl")
    public Result<List<ReconciliationDocListFileVo>> browseContract(@ApiParam(name = "ids", value = "主键列表") @RequestBody List<String> ids) {
        try {
            return Result.ok(this.reconciliationDocListService.browseContract(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 下载电子签章
     *
     * @param ids 数据主键列表
     * @return 结果
     */
    @ApiOperation(value = "下载")
    @PostMapping("download")
    public Result<List<ReconciliationDocListFileVo>> downloadContract(@ApiParam(name = "ids", value = "主键列表") @RequestBody List<String> ids) {
        try {
            return Result.ok(this.reconciliationDocListService.downloadContract(ids));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据id下载附件压缩包
     *
     * @param request  request
     * @param response response
     * @param ids      id列表
     * @throws IOException
     */
    @ApiOperation(value = "根据id下载附件压缩包")
    @RequestMapping(value = "/downloadZip", method = RequestMethod.GET)
    public void download(HttpServletRequest request, HttpServletResponse response, @RequestParam("ids") List<String> ids) throws IOException {
        byte[] bytes = this.reconciliationDocListService.findFileZipByIds(ids);
        if (bytes == null) {
            return;
        }
        String fileName =  LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "对账单压缩包.zip";
        // 附件文件下载
        this.writeResponseFile(request, response, bytes, fileName);
    }


    /**
     * 催签电子签章
     *
     * @param ids 数据主键列表
     * @return 结果
     */
    @ApiOperation(value = "催签")
    @PostMapping("notify")
    public Result<?> contractExpediting(@ApiParam(name = "ids", value = "主键列表") @RequestBody List<String> ids) {
        try {
            this.reconciliationDocListService.contractExpediting(ids);
            return Result.ok("操作成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 手动触发构建对账单
     */
    @ApiOperation(value = "手动触发定时任务")
    @GetMapping("handleManualGenerate")
    public Result handleManualGenerate(@RequestParam(value = "yearMonthDay",required = false) String yearMonthDay ) {
        try {
            Date date = new Date();
            if (StringUtils.isNotBlank(yearMonthDay)) {
                try {
                    date = DateUtil.parseDate(yearMonthDay, DateUtil.DEFAULT_YEAR_MONTH_DAY);
                } catch (Exception e) {
                    log.error("", e);
                    return Result.error("时间格式不正确,[" + DateUtil.DEFAULT_YEAR_MONTH_DAY + "]");
                }
            }
            if (Objects.isNull(date)) {
                return Result.error("时间格式不正确,[" + DateUtil.DEFAULT_YEAR_MONTH_DAY + "]");
            }
            boolean lockFlag = redisLockService.isLock(reconciliationDocBuildService.getBuildRedisLockKey(date));
            if (lockFlag) {
                return Result.error("上次生成对账尚未完成,请耐心等待!");
            }
            this.reconciliationDocBuildService.handleBuildReconciliation(date,loginUserService.getAbstractLoginUser());
            return Result.ok("对账中,请稍后查询结果!");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 手动触发构建对账单
     */
    @ApiOperation(value = "手动触发定时任务")
    @PostMapping("handleManualGenerateForOut")
    public Result<List<String>> handleManualGenerateForOut(@RequestParam(value = "yearMonthDay",required = false) String yearMonthDay ) {
        try {

            Date date = new Date();
            if (StringUtils.isNotBlank(yearMonthDay)) {
                try {
                    date = DateUtil.parseDate(yearMonthDay, DateUtil.DEFAULT_YEAR_MONTH_DAY);
                } catch (Exception e) {
                    log.error("", e);
                    return Result.error("时间格式不正确,[" + DateUtil.DEFAULT_YEAR_MONTH_DAY + "]");
                }
            }
            if (Objects.isNull(date)) {
                return Result.error("时间格式不正确,[" + DateUtil.DEFAULT_YEAR_MONTH_DAY + "]");
            }
            boolean lockFlag = redisLockService.isLock(reconciliationDocBuildService.getBuildRedisLockKey(date));
            if (lockFlag) {
                return Result.error("上次生成对账尚未完成,请耐心等待!");
            }
            List<String> idList = this.reconciliationDocBuildService.handleBuildReconciliationForOut(date,loginUserService.getAbstractLoginUser());
            return Result.ok(idList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 测试pdf生成
     */
    @ApiOperation(value = "测试pdf生成")
    @GetMapping("generatePdfTest")
    public Result<?> handleManualGenerate(ReconciliationDocListVo reconciliationDocListVo) {
        try {
//            this.reconciliationDocListService.generatePdf(reconciliationDocListVo,null,null);
//            this.reconciliationDocListService.createBatch(Lists.newArrayList(reconciliationDocListVo));
            return Result.ok("操作成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
