package com.biz.crm.tpm.business.reconciliation.doc.list.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationJobLogDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationJobLogVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationJobLogVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * TPM-任务执行日志(ReconciliationJobLog)表控制层
 *
 * @author liuyifan
 * @date 2023-02-22 11:04:04
 */
@Slf4j
@Api(tags = "TPM-任务执行日志")
@RestController
@RequestMapping(value = {"/v1/reconciliationJobLog/reconciliationJobLog"})
public class ReconciliationJobLogController {

    @Autowired(required = false)
    private ReconciliationJobLogVoService reconciliationJobLogVoService;

    /**
     * 查询分页列表
     *
     * @param pageable
     * @param paginationDto
     * @return
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<ReconciliationJobLogVo>> findByConditions(@PageableDefault(50) Pageable pageable,
                                                                 ReconciliationJobLogDto paginationDto) {
        try {
            Page<ReconciliationJobLogVo> result =
                this.reconciliationJobLogVoService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 详情
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "详情")
    @GetMapping(value = {"/findDetailById"})
    public Result<ReconciliationJobLogVo> findDetailById(@RequestParam("id") String id) {
        try {
            ReconciliationJobLogVo reconciliationJobLogVo = this.reconciliationJobLogVoService.findDetailById(id);
            return Result.ok(reconciliationJobLogVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 创建
     *
     * @param reconciliationJobLogVo
     * @return
     */
    @ApiOperation(value = "创建")
    @PostMapping(value = "")
    public Result<ReconciliationJobLogVo> create(@RequestBody ReconciliationJobLogVo reconciliationJobLogVo) {
        try {
            ReconciliationJobLogVo current = this.reconciliationJobLogVoService.create(reconciliationJobLogVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 更新
     *
     * @param reconciliationJobLogVo
     * @return
     */
    @ApiOperation(value = "更新")
    @PatchMapping(value = "")
    public Result<ReconciliationJobLogVo> update(@RequestBody ReconciliationJobLogVo reconciliationJobLogVo) {
        try {
            ReconciliationJobLogVo current = this.reconciliationJobLogVoService.update(reconciliationJobLogVo);
            return Result.ok(current);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用")
    @PatchMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        try {
            this.reconciliationJobLogVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        try {
            this.reconciliationJobLogVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 逻辑删除
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "逻辑删除")
    @DeleteMapping("/delete")
    public Result delete(@RequestParam("ids") List<String> ids) {
        try {
            this.reconciliationJobLogVoService.updateDelFlagByIds(ids);
            return Result.ok("删除成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
