package com.biz.crm.tpm.business.reconciliation.doc.list.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.ReconciliationSummaryDataDisplayService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationSummaryDataDisplayVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName ReconciliationSummaryDataDisplayController
 * @Description 对账单汇总数据展示controller
 * @AUTHOR WangJJ
 * @DATE 2023/5/30 14:18
 **/

@RestController
@RequestMapping("/v1/reconciliation/summary")
@Slf4j
@Api(tags = "对账单汇总列表")
public class ReconciliationSummaryDataDisplayController {

    @Autowired(required = false)
    private ReconciliationSummaryDataDisplayService reconciliationSummaryDataDisplayService;

    /**
     * 编辑数据
     */
    @ApiOperation(value = "更新对账单(重新生成对账单)")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "dto", value = "dto") @RequestBody ReconciliationSummaryDataDisplayDto dto) {
        try {
            this.reconciliationSummaryDataDisplayService.update(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据ID获取详情
     */
    @ApiOperation(value = "根据ID获取详情")
    @GetMapping("/findById")
    public Result<ReconciliationSummaryDataDisplayVo> findById(@ApiParam(name = "id", value = "ID") @RequestParam String id) {
        try {
            ReconciliationSummaryDataDisplayVo dataDisplayVo = this.reconciliationSummaryDataDisplayService.findById(id);
            return Result.ok(dataDisplayVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
