package com.biz.crm.tpm.business.reconciliation.doc.list.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.sd.sdk.dto.ReconciliationCallbackDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.PullSapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.SapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.service.SapReconciliationService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.SapReconciliationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/v1/sap/reconciliation")
@Slf4j
@Api(tags = "SAP客户对账数据")
public class SapReconciliationController {

    @Autowired(required = false)
    private SapReconciliationService sapReconciliationService;

    @ApiOperation(value = "查询SAP客户对账数据")
    @PostMapping("querySapReconciliation")
    public Result querySapReconciliation(@RequestBody PullSapReconciliationDto dto){
        return this.sapReconciliationService.querySapReconciliation(dto);
    }

    @ApiOperation(value = "测试对账数据回调保存")
    @PostMapping("testReconciliationCallback")
    public Result testReconciliationCallback(@RequestBody ReconciliationCallbackDto dto){
        this.sapReconciliationService.testReconciliationCallback(dto);
        return new Result<>();
    }

    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findBySapReconciliations")
    public Result<Page<SapReconciliationVo>> findBySapReconciliations(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                   @ApiParam(name = "sapReconciliationDto", value = "对账单据列表") SapReconciliationDto sapReconciliationDto) {
        try {
            Page<SapReconciliationVo> page = this.sapReconciliationService.findByReconciliations(pageable, sapReconciliationDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "手动执行定时任务")
    @GetMapping("/handleExecuteTask")
    public Result<?> handleExecuteTask(){
        try {
            this.sapReconciliationService.sync123DataScheduleTask();
            return Result.ok();
        }catch (Exception e){
            e.printStackTrace();
            return Result.error(e.getMessage());
        }
    }

}
