package com.biz.crm.tpm.business.reconciliation.doc.list.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author huojia
 * @date 2022年11月07日 17:10
 */
@Component
public class RenconciliationDocListRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_reconciliation_doc_list_data_view";
    }

    @Override
    public String desc() {
        return "TPM-对账单据列表";
    }

    @Override
    public String buildSql() {
        return " select a.* , DATE_FORMAT( a.reconciliation_month, '%Y-%m' ) AS reconciliationMonth " +
                "from tpm_reconciliation_doc_list a " +
                "where a.tenant_code = :tenantCode " +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
