package com.biz.crm.tpm.business.reconciliation.doc.list.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.util.Date;

/**
 * @author liuyifan
 */
@ApiModel(value = "ReconciliationCorrelationEntity", description = "TPM-对账单据关联数据")
@TableName("tpm_reconciliation_correlation")
@Data
@Entity(name = "tpm_reconciliation_correlation")
@org.hibernate.annotations.Table(appliesTo = "tpm_reconciliation_correlation", comment = "TPM-对账单据关联数据")
public class ReconciliationCorrelationEntity extends TenantFlagOpEntity {

    /**
     * 对账单编码
     */
    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    @Column(name = "statement_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '对账单编码 '")
    private String statementCode;


    /**
     * 对账单类型
     */
    @ApiModelProperty(name = "accountReconciliationType",value = "对账单类型",notes = "对账单类型")
    @Column(name = "account_reconciliation_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '对账单类型 '")
    private String accountReconciliationType;

    /**
     * 业务类型
     */
    @ApiModelProperty(name = "businessType",value = "业务类型",notes = "业务类型")
    @Column(name = "business_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务类型 '")
    private String businessType;

    /**
     * 关联数据编码ID
     */
    @ApiModelProperty(name = "associative_date",value = "关联数据编码ID",notes = "关联数据编码ID")
    @Column(name = "associative_date", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '关联数据编码ID'")
    private String associativeDate;

}
