package com.biz.crm.tpm.business.reconciliation.doc.list.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月17日 9:56
 */
@ApiModel(value = "ReconciliationDocListEntity", description = "TPM-对账单据列表")
@TableName("tpm_reconciliation_doc_list")
@Data
@Entity(name = "tpm_reconciliation_doc_list")
@org.hibernate.annotations.Table(appliesTo = "tpm_reconciliation_doc_list", comment = "TPM-对账单据列表")
@Table(name = "tpm_reconciliation_doc_list", indexes = {@Index(name = "statement_code_idx", columnList = "statement_code", unique = true)})
public class ReconciliationDocListEntity extends TenantFlagOpEntity {

    /**
     * 对账单编码
     */
    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    @Column(name = "statement_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '对账单编码 '")
    private String statementCode;

    /**
     * 对账单状态
     */
    @ApiModelProperty(name = "statementStatus",value = "对账单状态",notes = "对账单状态")
    @Column(name = "statement_status", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '对账单状态 '")
    private String statementStatus;
    /**
     * 对账年月
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @ApiModelProperty(name = "reconciliationMonth",value = "对账年月", notes = "对账年月")
    @Column(name = "reconciliation_month", columnDefinition = "datetime COMMENT '对账年月 '")
    private Date reconciliationMonth;
    /**
     * 对账单类型
     */
    @ApiModelProperty(name = "accountReconciliationType",value = "对账单类型",notes = "对账单类型")
    @Column(name = "account_reconciliation_type", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '对账单类型 '")
    private String accountReconciliationType;
    /**
     * 业态
     */
    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    @Column(name = "business_format_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业态 '")
    private String businessFormatCode;
    /**
     * 业务单元
     */
    @ApiModelProperty(name = "businessUnitName",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元 '")
    private String businessUnitName;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元 '")
    private String businessUnitCode;
    /**
     * 销售部门(大区)
     */
    @ApiModelProperty(name = "salesOrgName",value = "销售部门(大区)",notes = "销售部门(大区)")
    @Column(name = "sales_org_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售部门(大区) '")
    private String salesOrgName;
    /**
     * 销售部门编码
     */
    @ApiModelProperty(name = "salesOrgCode",value = "销售部门编码",notes = "销售部门编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码 '")
    private String salesOrgCode;
    /**
     * 销售组(省区)
     */
    @ApiModelProperty(name = "salesGroupName",value = "销售组(省区)",notes = "销售组(省区)")
    @Column(name = "sales_group_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组(省区) '")
    private String salesGroupName;
    /**
     * 销售组编码
     */
    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    @Column(name = "sales_group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码 '")
    private String salesGroupCode;
    /**
     * 销售机构
     */
    @ApiModelProperty(name = "salesInstitutionName",value = "销售机构",notes = "销售机构")
    @Column(name = "sales_institution_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售机构 '")
    private String salesInstitutionName;
    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码",notes = "销售机构编码")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码 '")
    private String salesInstitutionCode;
    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName",value = "客户名称",notes = "客户名称")
    @Column(name = "customer_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户名称 '")
    private String customerName;
    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码 '")
    private String customerCode;
    /**
     * ECRM客户编码
     */
    @ApiModelProperty(name = "customerErpCode",value = "ECRM客户编码",notes = "ECRM客户编码")
    @Column(name = "customer_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'ECRM客户编码 '")
    private String customerErpCode;
    /**
     * 接收人姓名
     */
    @ApiModelProperty(name = "recipientName",value = "接收人姓名",notes = "接收人姓名")
    @Column(name = "recipient_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '接收人姓名 '")
    private String recipientName;
    /**
     * 接收人手机号
     */
    @ApiModelProperty(name = "receiverTelephone",value = "接收人手机号",notes = "接收人手机号")
    @Column(name = "receiver_telephone", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '接收人手机号 '")
    private String receiverTelephone;
    /**
     * 接收人邮箱
     */
    @ApiModelProperty(name = "recipientEmail",value = "接收人邮箱",notes = "接收人邮箱")
    @Column(name = "recipient_email", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '接收人邮箱 '")
    private String recipientEmail;

    @ApiModelProperty(name = "accountReconciliationRuleCode",value = "对账规则编码",notes = "对账规则编码")
    @Column(name = "account_reconciliation_rule_code", nullable = true, length = 20, columnDefinition = "VARCHAR(20) COMMENT '对账规则编码 '")
    private String accountReconciliationRuleCode;

    /**
     * 对账单完成时间
     */
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(name = "statementCompletionTime",value = "对账单完成时间", notes = "对账单完成时间")
    @Column(name = "statement_completion_time", columnDefinition = "datetime COMMENT '对账单完成时间 '")
    private Date statementCompletionTime;

    /**
     * 计算开始时间
     */
    @ApiModelProperty(value = "计算开始时间", notes = "")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "start_date", columnDefinition = "datetime COMMENT '计算开始时间 '")
    private Date startDate;


    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "计算结束时间", notes = "")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "end_date", columnDefinition = "datetime COMMENT '计算结束时间 '")
    private Date endDate;

    /**
     * 客户拒绝签单原因
     */
    @ApiModelProperty(name = "reasonForRejection",value = "客户拒绝签单原因",notes = "客户拒绝签单原因")
    @Column(name = "reason_for_rejection", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户拒绝签单原因 '")
    private String reasonForRejection;
    /**
     * 对账标记
     */
    @ApiModelProperty(name = "reconciliationFlag",value = "对账标记",notes = "对账标记")
    @Column(name = "reconciliation_flag", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '对账标记 '")
    private String reconciliationFlag;


    @ApiModelProperty("合同id")
    @Column(name = "contract_id", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '合同id '")
    private String contractId;


    @ApiModelProperty("文档id")
    @Column(name = "documents_id", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '文档id '")
    private String documentsId;


    @ApiModelProperty("hr组织编码")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'hr组织编码'")
    private String orgCode;

    @ApiModelProperty("hr组织名称")
    @Column(name = "org_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'hr组织名称'")
    private String orgName;



}
