package com.biz.crm.tpm.business.reconciliation.doc.list.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月17日 9:56
 */
@ApiModel(value = "ReconciliationDocListFileEntity", description = "TPM-对账单据文件")
@TableName("tpm_reconciliation_doc_list_file")
@Data
@Entity(name = "tpm_reconciliation_doc_list_file")
@org.hibernate.annotations.Table(appliesTo = "tpm_reconciliation_doc_list_file", comment = "TPM-对账单据文件")
public class ReconciliationDocListFileEntity extends FileEntity {

    /**
     * 对账单编码
     */
    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    @Column(name = "statement_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '对账单编码 '")
    private String statementCode;


    /**
     * 文件类型
     */
    @ApiModelProperty(name = "fileType",value = "文件类型",notes = "文件类型")
    @Column(name = "file_type", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '文件类型 '")
    private String fileType;

    /**
     * 相对路径
     */
    @ApiModelProperty(name = "relativeLocal",value = "相对路径",notes = "相对路径")
    @Column(name = "relative_local", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '相对路径'")
    private String relativeLocal;



}
