package com.biz.crm.tpm.business.reconciliation.doc.list.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月17日 9:56
 */
@ApiModel(value = "ReconciliationJobLogEntity", description = "TPM-任务执行日志")
@TableName("tpm_reconciliation_job_log")
@Data
@Entity(name = "tpm_reconciliation_job_log")
@org.hibernate.annotations.Table(appliesTo = "tpm_reconciliation_job_log", comment = "TPM-任务执行日志")
@Table(name = "tpm_reconciliation_job_log", indexes = {@Index(name = "tpm_reconciliation_job_log_search_index",
        columnList = "business_format_code,business_unit_code,start_date,end_date,account_reconciliation_rule_code", unique = true)})

public class ReconciliationJobLogEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "executionStartTime", value = "执行开始时间", notes = "执行开始时间")
    @Column(name = "execution_start_time", nullable = false,
            columnDefinition = "datetime COMMENT '执行开始时间 '")
    private Date executionStartTime;

    @ApiModelProperty(name = "statementCode", value = "执行结束时间", notes = "执行结束时间")
    @Column(name = "execution_end_time", nullable = true, columnDefinition = "datetime COMMENT '执行结束时间 '")
    private Date executionEndTime;

    @ApiModelProperty(name = "executionMillisecond", value = "执行耗时（毫秒）", notes = "执行耗时（毫秒）")
    @Column(name = "execution_millisecond", nullable = true,
            columnDefinition = "int(12) COMMENT '执行耗时（毫秒） '")
    private Integer executionMillisecond;

    @ApiModelProperty(name = "isSuccess", value = "是否成功", notes = "是否成功")
    @Column(name = "is_success", nullable = false, columnDefinition = "CHAR(1) COMMENT '是否成功 '")
    private Boolean isSuccess;

    @ApiModelProperty(name = "errorMsg", value = "错误信息", notes = "错误信息")
    @Column(name = "error_msg", nullable = true, length = 128,
            columnDefinition = "varchar(128) COMMENT '错误信息 '")
    private String errorMsg;

    @ApiModelProperty(name = "retryTimes", value = "失败重试次数", notes = "失败重试次数")
    @Column(name = "retry_times", nullable = true,
            columnDefinition = "int(10) COMMENT '失败重试次数 '")
    private Integer retryTimes;


    /**
     * 业态编码
     */
    @ApiModelProperty(value = "businessFormatCode", notes = "业态编码")
    @Column(name = "business_format_code", nullable = false,
            columnDefinition = "varchar(4) COMMENT '业态编码 '")
    private String businessFormatCode;

    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "businessUnitCode", notes = "业务单元编码")
    @Column(name = "business_unit_code", nullable = false,
            columnDefinition = "varchar(12) COMMENT '业务单元编码 '")
    private String businessUnitCode;

    /**
     * 计算开始时间
     */
    @ApiModelProperty(value = "startDate", notes = "计算开始时间")
    @Column(name = "start_date", nullable = false, columnDefinition = "datetime COMMENT '计算开始时间 '")
    private Date startDate;

    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "endDate", notes = "计算结束时间")
    @Column(name = "end_date", nullable = false, columnDefinition = "datetime COMMENT '计算结束时间 '")
    private Date endDate;

    /**
     * 计算结束时间
     */
    @ApiModelProperty(value = "calculationTime", notes = "计算时间")
    @Column(name = "calculation_time", nullable = true, columnDefinition = "datetime COMMENT '计算时间 '")
    private Date calculationTime;

    @ApiModelProperty(name = "accountReconciliationRuleCode", value = "对账规则编码", notes = "对账规则编码")
    @Column(name = "account_reconciliation_rule_code", nullable = false, length = 20, columnDefinition = "varchar(20) COMMENT '对账规则编码 '")
    private String accountReconciliationRuleCode;

    @ApiModelProperty(name = "accountReconciliationType", value = "对账类型", notes = "对账类型")
    @Column(name = "account_reconciliation_type", nullable = false, columnDefinition = "varchar(24) COMMENT '对账类型 '")
    private String accountReconciliationType;
}
