package com.biz.crm.tpm.business.reconciliation.doc.list.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName ReconciliationSummaryDataDisplayEntityDetail
 * @Description 分子批复明细表
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 14:11
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDetailHeadApproveEntity", description = "TPM-主体批复对账单明细表")
@TableName("tpm_reconciliation_summary_display_detail_head_approve")
@Data
@Entity(name = "tpm_reconciliation_summary_display_detail_head_approve")
@org.hibernate.annotations.Table(appliesTo = "tpm_reconciliation_summary_display_detail_head_approve", comment = "TPM-主体批复对账单明细表")
@Table(name = "tpm_reconciliation_summary_display_detail_head_approve", indexes = {
        @Index(name = "statement_code_index1", columnList = "statement_code", unique = false),
})
public class ReconciliationSummaryDataDisplayDetailHeadApproveEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    @Column(name = "statement_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '对账单编码'")
    private String statementCode;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    @Column(name = "business_format_code", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码",notes = "销售机构编码")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构ERP编码",notes = "销售机构ERP编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionName",value = "销售机构名称",notes = "销售机构名称")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区编码'")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区ERP编码")
    @Column(name = "sales_region_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区ERP编码'")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区名称")
    @Column(name = "sales_region_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售大区名称'")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)ERP编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)ERP编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售组织(组)编码'")
    private String salesOrgName;

    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "customerName",value = "客户名称",notes = "客户名称")
    @Column(name = "customer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "activityFormCode",value = "活动形式编码",notes = "活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName",value = "活动形式名称",notes = "活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "budgetItemCode",value = "预算项目编码",notes = "预算项目编码")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码'")
    private String budgetItemCode;

    @ApiModelProperty(name = "budgetItemName",value = "预算项目名称",notes = "预算项目名称")
    @Column(name = "budget_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '预算项目名称'")
    private String budgetItemName;

    @ApiModelProperty("商品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '商品编码'")
    private String productCode;

    @ApiModelProperty("商品名称")
    @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品名称'")
    private String productName;

    @ApiModelProperty(name = "productBrandCode",value = "品牌编码",notes = "品牌编码")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName",value = "品牌名称",notes = "品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty("产品品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "varchar(64) COMMENT '产品品类编码'")
    private String productCategoryCode;

    @ApiModelProperty("产品品类名称")
    @Column(name = "product_category_name", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '产品品类名称'")
    private String productCategoryName;

    @ApiModelProperty("费用合计")
    @Column(name = "total_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFee;

    @ApiModelProperty("费用申请")
    @Column(name = "apply_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用申请'")
    private BigDecimal applyFee;

    @ApiModelProperty("客户承担费用")
    @Column(name = "customer_fee_amount", length = 24,columnDefinition = "decimal(24,6) COMMENT '客户承担费用'")
    private BigDecimal customerFeeAmount;

    @ApiModelProperty("活动开始时间")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginDate;

    @ApiModelProperty("活动结束时间")
    @Column(name = "activity_end_date", columnDefinition = "datetime COMMENT '活动结束时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndDate;

}
