package com.biz.crm.tpm.business.reconciliation.doc.list.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @ClassName ReconciliationSummaryDataDisplayEntityDetail
 * @Description 分子批复明细表
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 14:11
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDetailHeadAuditEntity", description = "TPM-主体结案对账单明细表")
@TableName("tpm_reconciliation_summary_display_detail_head_audit")
@Data
@Entity(name = "tpm_reconciliation_summary_display_detail_head_audit")
@org.hibernate.annotations.Table(appliesTo = "tpm_reconciliation_summary_display_detail_head_audit", comment = "TPM-主体结案对账单明细表")
@Table(name = "tpm_reconciliation_summary_display_detail_head_audit", indexes = {
        @Index(name = "statement_code_index1", columnList = "statement_code", unique = false),
})
public class ReconciliationSummaryDataDisplayDetailHeadAuditEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    @Column(name = "statement_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '对账单编码'")
    private String statementCode;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    @Column(name = "business_format_code", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码",notes = "销售机构编码")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构ERP编码",notes = "销售机构ERP编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionName",value = "销售机构名称",notes = "销售机构名称")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区编码'")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区ERP编码")
    @Column(name = "sales_region_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区ERP编码'")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区名称")
    @Column(name = "sales_region_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售大区名称'")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)ERP编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)ERP编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售组织(组)编码'")
    private String salesOrgName;

    @ApiModelProperty(name = "center",value = "中心",notes = "中心")
    @Column(name = "center", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '中心'")
    private String center;

    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "customerName",value = "客户名称",notes = "客户名称")
    @Column(name = "customer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "firstChannelName",value = "一级管理渠道名称",notes = "一级管理渠道名称")
    @Column(name = "first_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '一级管理渠道名称'")
    private String firstChannelName;

    @ApiModelProperty(name = "secondChannelName",value = "二级管理渠道名称",notes = "二级管理渠道名称")
    @Column(name = "second_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '二级管理渠道名称'")
    private String secondChannelName;

    @ApiModelProperty(name = "budgetItemCode",value = "预算项目编码",notes = "预算项目编码")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码'")
    private String budgetItemCode;

    @ApiModelProperty(name = "budgetItemName",value = "预算项目名称",notes = "预算项目名称")
    @Column(name = "budget_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '预算项目名称'")
    private String budgetItemName;

    @ApiModelProperty("商品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '商品编码'")
    private String productCode;

    @ApiModelProperty("商品名称")
    @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品名称'")
    private String productName;

    @ApiModelProperty(name = "productBrandCode",value = "品牌编码",notes = "品牌编码")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName",value = "品牌名称",notes = "品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty("产品品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "varchar(64) COMMENT '产品品类编码'")
    private String productCategoryCode;

    @ApiModelProperty("产品品类名称")
    @Column(name = "product_category_name", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '产品品类名称'")
    private String productCategoryName;

    @ApiModelProperty(name = "activityFormCode",value = "活动形式编码",notes = "活动形式编码")
    @Column(name = "activity_form_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty(name = "activityFormName",value = "活动形式名称",notes = "活动形式名称")
    @Column(name = "activity_form_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty("活动开始时间")
    @Column(name = "activity_begin_time", columnDefinition = "datetime COMMENT '活动开始时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间")
    @Column(name = "activity_end_time", columnDefinition = "datetime COMMENT '活动结束时间'")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndTime;

    @ApiModelProperty("经销商承担费用")
    @Column(name = "dealer_undertake_amount", length = 24,columnDefinition = "decimal(24,6) COMMENT '经销商承担费用'")
    private BigDecimal dealerUndertakeAmount;

    @ApiModelProperty("申请费用")
    @Column(name = "apply_amount", length = 24,columnDefinition = "decimal(24,6) COMMENT '申请费用'")
    private BigDecimal applyAmount;

    @ApiModelProperty("本次应结案金额")
    @Column(name = "current_audit_amount", length = 24,columnDefinition = "decimal(24,6) COMMENT '本次应结案金额'")
    private BigDecimal currentAuditAmount;

    @ApiModelProperty("扣税金额")
    @Column(name = "deduction_tax_amount", length = 24,columnDefinition = "decimal(24,6) COMMENT '扣税金额'")
    private BigDecimal deductionTaxAmount;

    @ApiModelProperty("本次实际结案金额")
    @Column(name = "current_actual_audit_amount", length = 24,columnDefinition = "decimal(24,6) COMMENT '本次实际结案金额'")
    private BigDecimal currentActualAuditAmount;

    @ApiModelProperty("上账方式")
    @Column(name = "account_method", length = 10,columnDefinition = "VARCHAR(10) COMMENT '上账方式'")
    private String accountMethod;

    @ApiModelProperty("上账单号")
    @Column(name = "account_number", length = 32,columnDefinition = "VARCHAR(32) COMMENT '上账单号'")
    private String accountNumber;

    @ApiModelProperty("折扣金额")
    @Column(name = "discount_amount", length = 24,columnDefinition = "decimal(24,6) COMMENT '折扣金额'")
    private BigDecimal discountAmount;

    @ApiModelProperty("报销金额")
    @Column(name = "reimburse_amount", length = 24,columnDefinition = "decimal(24,6) COMMENT '报销金额'")
    private BigDecimal reimburseAmount;

    @ApiModelProperty("考核扣款")
    @Column(name = "examine_circular_amount", length = 24,columnDefinition = "decimal(24,6) COMMENT '考核扣款'")
    private BigDecimal examineCircularAmount;

    @ApiModelProperty("便签名称（取自审批工作流主题）")
    @Column(name = "process_title", length = 255, columnDefinition = "VARCHAR(255) COMMENT '便签名称(取自审批工作流主题)'")
    private String processTitle;

}
