package com.biz.crm.tpm.business.reconciliation.doc.list.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @ClassName ReconciliationSummaryDataDisplayEntityDetail
 * @Description 分子批复明细表
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 14:11
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayDetailSubCommunicateEntity", description = "TPM-分子往来对账单明细表")
@TableName("tpm_reconciliation_summary_display_detail_sub_communicate")
@Data
@Entity(name = "tpm_reconciliation_summary_display_detail_sub_communicate")
@org.hibernate.annotations.Table(appliesTo = "tpm_reconciliation_summary_display_detail_sub_communicate", comment = "TPM-分子往来对账单明细表")
@Table(name = "tpm_reconciliation_summary_display_detail_sub_communicate", indexes = {
        @Index(name = "statement_code_index1", columnList = "statement_code", unique = false),
})
public class ReconciliationSummaryDataDisplayDetailSubCommunicateEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "statementCode",value = "对账单编码",notes = "对账单编码")
    @Column(name = "statement_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '对账单编码'")
    private String statementCode;

    @ApiModelProperty(name = "vkorg",value = "销售机构",notes = "销售机构")
    @Column(name = "vkorg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构'")
    private String vkorg;

    @ApiModelProperty("分销渠道")
    @Column(name = "vtweg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分销渠道'")
    private String vtweg;

    @ApiModelProperty("渠道描述")
    @Column(name = "vtext", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道描述'")
    private String vtext;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    @Column(name = "business_format_code", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码",notes = "销售机构编码")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构ERP编码",notes = "销售机构ERP编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionName",value = "销售机构名称",notes = "销售机构名称")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区编码'")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区ERP编码")
    @Column(name = "sales_region_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区ERP编码'")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区名称")
    @Column(name = "sales_region_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售大区名称'")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)ERP编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)ERP编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售组织(组)编码'")
    private String salesOrgName;

    @ApiModelProperty(name = "budgetItemCode",value = "预算项目编码",notes = "预算项目编码")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目编码'")
    private String budgetItemCode;

    @ApiModelProperty(name = "budgetItemName",value = "预算项目名称",notes = "预算项目名称")
    @Column(name = "budget_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '预算项目名称'")
    private String budgetItemName;

    @ApiModelProperty("商品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '商品编码'")
    private String productCode;

    @ApiModelProperty("商品名称")
    @Column(name = "product_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品名称'")
    private String productName;

    @ApiModelProperty(name = "productBrandCode",value = "品牌编码",notes = "品牌编码")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName",value = "品牌名称",notes = "品牌名称")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty("产品品类编码")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "varchar(64) COMMENT '产品品类编码'")
    private String productCategoryCode;

    @ApiModelProperty("产品品类名称")
    @Column(name = "product_category_name", nullable = true, length = 256, columnDefinition = "varchar(256) COMMENT '产品品类名称'")
    private String productCategoryName;

    @ApiModelProperty("售达方")
    @Column(name = "kunrg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方'")
    private String kunrg;

    @ApiModelProperty("客户全称")
    @Column(name = "kunag_txt", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户全称'")
    private String kunagTxt;

    @ApiModelProperty("日期")
    @Column(name = "fkdat", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '日期'")
    private String fkdat;

    @ApiModelProperty("财务单据名称")
    @Column(name = "zdoc_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '财务单据名称'")
    private String zdocName;

    @ApiModelProperty("实收金额")
    @Column(name = "zsh", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '实收金额'")
    private String zsh;

    @ApiModelProperty("付款方式")
    @Column(name = "zfkfs", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '付款方式'")
    private String zfkfs;

    @ApiModelProperty("预收账款变动原因")
    @Column(name = "zyszk_bdyy", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预收账款变动原因'")
    private String zyszkBdyy;

    @ApiModelProperty("销售发票编号")
    @Column(name = "vbeln", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售发票编号'")
    private String vbeln;

    @ApiModelProperty("发票行项目")
    @Column(name = "posnr", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票行项目'")
    private String posnr;

    @ApiModelProperty("订单行项目类别")
    @Column(name = "pstyv", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '订单行项目类别'")
    private String pstyv;

    @ApiModelProperty("订单行项目类别")
    @Column(name = "pstyv_t", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '订单行项目类别'")
    private String pstyvT;

    @ApiModelProperty("会计凭证")
    @Column(name = "belnr", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '会计凭证'")
    private String belnr;

    @ApiModelProperty("销售订单编号")
    @Column(name = "aubel", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售订单编号'")
    private String aubel;

    @ApiModelProperty("交货单编号")
    @Column(name = "vgbel", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '交货单编号'")
    private String vgbel;

    @ApiModelProperty("商品")
    @Column(name = "arktx", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商品'")
    private String arktx;

    @ApiModelProperty("标准价")
    @Column(name = "netwr_hs", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '标准价'")
    private String netwrHs;

    @ApiModelProperty("实际价")
    @Column(name = "netwr_zk", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '实际价'")
    private String netwrZk;

    @ApiModelProperty("折扣率(%)")
    @Column(name = "ratio", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '折扣率(%)'")
    private String ratio;

    @ApiModelProperty("数量")
    @Column(name = "fkimg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数量'")
    private String fkimg;

    @ApiModelProperty("单位")
    @Column(name = "vrkme", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位'")
    private String vrkme;

    @ApiModelProperty("基本单位数量")
    @Column(name = "fklmg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '基本单位数量'")
    private String fklmg;

    @ApiModelProperty("基本单位")
    @Column(name = "meins", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '基本单位'")
    private String meins;

    @ApiModelProperty("折扣金额")
    @Column(name = "kzwi6", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '折扣金额'")
    private String kzwi6;

    @ApiModelProperty("应收金额")
    @Column(name = "kzwi1", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '应收金额'")
    private String kzwi1;

    @ApiModelProperty("应收余额")
    @Column(name = "zysye", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '应收余额'")
    private String zysye;

    @ApiModelProperty("随单费用折扣值")
    @Column(name = "zsdfy", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '随单费用折扣值'")
    private String zsdfy;

    @ApiModelProperty("发票固定折扣值")
    @Column(name = "zk01", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票固定折扣值'")
    private String zk01;

    @ApiModelProperty("发票费用折扣值")
    @Column(name = "zfpfy", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票费用折扣值'")
    private String zfpfy;

    @ApiModelProperty("商品编号")
    @Column(name = "matnr", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商品编号'")
    private String matnr;

    @ApiModelProperty("送达方")
    @Column(name = "kunwe", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '送达方'")
    private String kunwe;

    @ApiModelProperty("送达方名称")
    @Column(name = "kunwe_txt", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '送达方名称'")
    private String kunweTxt;

    @ApiModelProperty("客户订单号")
    @Column(name = "bstnk", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户订单号'")
    private String bstnk;

    @ApiModelProperty("利润中心")
    @Column(name = "prctr", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '利润中心'")
    private String prctr;

}
