package com.biz.crm.tpm.business.reconciliation.doc.list.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @ClassName ReconciliationSummaryDataDisplayEntity
 * @Description 对账单汇总数据展示
 * @AUTHOR WangJJ
 * @DATE 2023/5/24 14:34
 **/
@ApiModel(value = "ReconciliationSummaryDataDisplayEntity", description = "TPM-对账单汇总数据展示")
@TableName("tpm_reconciliation_summary_display")
@Data
@Entity(name = "tpm_reconciliation_summary_display")
@org.hibernate.annotations.Table(appliesTo = "tpm_reconciliation_summary_display", comment = "TPM-对账单汇总数据展示")
@Table(name = "tpm_reconciliation_summary_display", indexes = {
        @Index(name = "statement_code-idx", columnList = "statement_code", unique = true)})
public class ReconciliationSummaryDataDisplayEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "reconciliationType",value = "对账单编码",notes = "对账单编码")
    @Column(name = "statement_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '对账单编码'")
    private String statementCode;

    @ApiModelProperty(name = "reconciliationType",value = "对账单类型",notes = "对账单类型")
    @Column(name = "reconciliation_type", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '对账单类型'")
    private String reconciliationType;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    @Column(name = "business_format_code", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "channelCode",value = "渠道编码",notes = "渠道编码")
    @Column(name = "channel_code", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码",notes = "销售机构编码")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionErpCode",value = "销售机构ERP编码",notes = "销售机构ERP编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构ERP编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionName",value = "销售机构名称",notes = "销售机构名称")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区编码'")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区ERP编码")
    @Column(name = "sales_region_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售大区ERP编码'")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区名称")
    @Column(name = "sales_region_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售大区名称'")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)ERP编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = " varchar(32) COMMENT '所属销售组织(组)ERP编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = " varchar(128) COMMENT '所属销售组织(组)编码'")
    private String salesOrgName;

    @ApiModelProperty(name = "customerCode",value = "客户编码",notes = "客户编码")
    @Column(name = "customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(name = "customerErpCode",value = "客户MDG编码",notes = "客户MDG编码")
    @Column(name = "customer_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户MDG编码'")
    private String customerErpCode;

    @ApiModelProperty(name = "customerName",value = "客户名称",notes = "客户名称")
    @Column(name = "customer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "reconciliationYearMonth",value = "对账年月",notes = "对账年月")
    @Column(name = "reconciliation_year_month", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '对账年月'")
    private String reconciliationYearMonth;

    @ApiModelProperty(name = "thisMonthFeeTotalAmount",value = "本月费用合计金额（元）",notes = "本月费用合计金额（元）")
    @Column(name = "this_month_fee_total_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本月费用合计金额（元）'")
    private BigDecimal thisMonthFeeTotalAmount;

    @ApiModelProperty(name = "thisMonthFeeApplyAmount",value = "本月费用申请金额（元）",notes = "本月费用申请金额（元）")
    @Column(name = "this_month_fee_apply_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本月费用申请金额（元）'")
    private BigDecimal thisMonthFeeApplyAmount;

    @ApiModelProperty(name = "thisMonthCustomerBearTotalAmount",value = "本月客户承担合计金额（元）",notes = "本月客户承担合计金额（元）")
    @Column(name = "this_month_customer_bear_total_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本月客户承担合计金额（元）'")
    private BigDecimal thisMonthCustomerBearTotalAmount;

    @ApiModelProperty(name = "promotionTotalAmount",value = "报销合计金额",notes = "报销合计金额")
    @Column(name = "promotion_total_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '报销合计金额'")
    private BigDecimal promotionTotalAmount;

    @ApiModelProperty(name = "discountTotalAmount",value = "折扣合计金额",notes = "折扣合计金额")
    @Column(name = "discount_total_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '折扣合计金额'")
    private BigDecimal discountTotalAmount;

    @ApiModelProperty(name = "promotionAndDiscountTotalAmount",value = "报销和折扣合计金额",notes = "报销和折扣合计金额")
    @Column(name = "promotion_and_discount_total_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '折扣合计金额'")
    private BigDecimal promotionAndDiscountTotalAmount;

    @ApiModelProperty(name = "followCarAmount",value = "随车金额",notes = "随车金额")
    @Column(name = "follow_car_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '随车金额'")
    private BigDecimal followCarAmount;

    @ApiModelProperty(name = "examineCircularAmount",value = "考核扣款金额",notes = "考核扣款金额")
    @Column(name = "examine_circular_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '考核扣款金额'")
    private BigDecimal examineCircularAmount;

    @ApiModelProperty(name = "totalAmount",value = "合计金额",notes = "合计金额")
    @Column(name = "total_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '合计金额'")
    private BigDecimal totalAmount;

    @ApiModelProperty(name = "thisPeriodHandleAmount",value = "本期处理费用",notes = "本期处理费用")
    @Column(name = "this_period_handle_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本期处理费用'")
    private BigDecimal thisPeriodHandleAmount;

    @ApiModelProperty(name = "inProcessExpenseTotal",value = "事中费用合计",notes = "事中费用合计")
    @Column(name = "in_process_expense_total", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '事中费用合计'")
    private BigDecimal inProcessExpenseTotal;

    @ApiModelProperty(name = "otherCheckItem",value = "其他核对项",notes = "其他核对项")
    @Column(name = "other_check_item", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '其他核对项'")
    private BigDecimal otherCheckItem;

    @ApiModelProperty(name = "beginPeriodDiscountPoolBalance",value = "期初折扣池余额",notes = "期初折扣池余额")
    @Column(name = "begin_period_discount_pool_balance", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '期初折扣池余额'")
    private BigDecimal beginPeriodDiscountPoolBalance;

    @ApiModelProperty(name = "thisMonthShouldHandleAmount",value = "本月应处理费用",notes = "本月应处理费用")
    @Column(name = "this_month_should_handle_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本月应处理费用'")
    private BigDecimal thisMonthShouldHandleAmount;

    @ApiModelProperty(name = "thisMonthActualDiscountAmount",value = "本月实际折扣金额",notes = "本月实际折扣金额")
    @Column(name = "this_month_actual_discount_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本月实际折扣金额'")
    private BigDecimal thisMonthActualDiscountAmount;

    @ApiModelProperty(name = "thisMonthInvoiceReimburseAmount",value = "本月发票报销金额",notes = "本月发票报销金额")
    @Column(name = "this_month_invoice_reimburse_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本月发票报销金额'")
    private BigDecimal thisMonthInvoiceReimburseAmount;

    @ApiModelProperty(name = "endPeriodFeePoolBalance",value = "期末费用池余额",notes = "期末费用池余额")
    @Column(name = "end_period_fee_pool_balance", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '期末费用池余额'")
    private BigDecimal endPeriodFeePoolBalance;

    @ApiModelProperty(name = "costTransfer",value = "费用转移",notes = "费用转移")
    @Column(name = "cost_transfer", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '费用转移'")
    private BigDecimal costTransfer;

    @ApiModelProperty(name = "beginPeriodBalance",value = "期初余额",notes = "期初余额")
    @Column(name = "begin_period_balance", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '期初余额'")
    private BigDecimal beginPeriodBalance;

    @ApiModelProperty(name = "thisPeriodBackMoney",value = "本期回款",notes = "本期回款")
    @Column(name = "this_period_back_money", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本期回款'")
    private BigDecimal thisPeriodBackMoney;

    @ApiModelProperty(name = "expenseReimburseUpAccount",value = "费用报销上账",notes = "费用报销上账")
    @Column(name = "expense_reimburse_up_account", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '费用报销上账'")
    private BigDecimal expenseReimburseUpAccount;

    @ApiModelProperty(name = "thisPeriodStockInAmount",value = "本期进货金额",notes = "本期进货金额")
    @Column(name = "this_period_stock_in_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本期进货金额'")
    private BigDecimal thisPeriodStockInAmount;

    @ApiModelProperty(name = "thisPeriodSalesDiscount",value = "本期销售折扣",notes = "本期销售折扣")
    @Column(name = "this_period_sales_discount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本期销售折扣'")
    private BigDecimal thisPeriodSalesDiscount;

    @ApiModelProperty(name = "endPeriodBalance",value = "期末余额",notes = "期末余额")
    @Column(name = "end_period_balance", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '期末余额'")
    private BigDecimal endPeriodBalance;

    @ApiModelProperty(name = "earnestMoney",value = "保证金金额",notes = "保证金金额")
    @Column(name = "earnest_money", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '保证金金额'")
    private BigDecimal earnestMoney;

    @ApiModelProperty("hr组织编码")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'hr组织编码'")
    private String orgCode;

    @ApiModelProperty("hr组织名称")
    @Column(name = "org_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'hr组织名称'")
    private String orgName;

}
