package com.biz.crm.tpm.business.reconciliation.doc.list.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@ApiModel(value = "SapReconciliationEntity", description = "TPM-sap客户对账数据")
@TableName("tpm_sap_reconciliation")
@Data
@Entity(name = "tpm_sap_reconciliation")
@org.hibernate.annotations.Table(appliesTo = "tpm_sap_reconciliation", comment = "TPM-sap客户对账数据")
@Table(
        name = "tpm_sap_reconciliation",
        indexes = {
                @Index(name = "tpm_sap_reconciliation_inx1", columnList = "del_flag,tenant_code,fkdat", unique = false),
        }
)
public class SapReconciliationEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "vkorg",value = "销售机构",notes = "销售机构")
    @Column(name = "vkorg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构'")
    private String vkorg;

    @ApiModelProperty("分销渠道")
    @Column(name = "vtweg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分销渠道'")
    private String vtweg;

    @ApiModelProperty("渠道描述")
    @Column(name = "vtext", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道描述'")
    private String vtext;

    @ApiModelProperty("售达方")
    @Column(name = "kunrg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '售达方'")
    private String kunrg;

    @ApiModelProperty("客户全称")
    @Column(name = "kunag_txt", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户全称'")
    private String kunagTxt;

    @ApiModelProperty("日期")
    @Column(name = "fkdat", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '日期'")
    private String fkdat;

    @ApiModelProperty("财务单据名称")
    @Column(name = "zdoc_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '财务单据名称'")
    private String zdocName;

    @ApiModelProperty("实收金额")
    @Column(name = "zsh", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '实收金额'")
    private String zsh;

    @ApiModelProperty("付款方式")
    @Column(name = "zfkfs", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '付款方式'")
    private String zfkfs;

    @ApiModelProperty("预收账款变动原因")
    @Column(name = "zyszk_bdyy", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预收账款变动原因'")
    private String zyszkBdyy;

    @ApiModelProperty("销售发票编号")
    @Column(name = "vbeln", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售发票编号'")
    private String vbeln;

    @ApiModelProperty("发票行项目")
    @Column(name = "posnr", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票行项目'")
    private String posnr;

    @ApiModelProperty("订单行项目类别")
    @Column(name = "pstyv", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '订单行项目类别'")
    private String pstyv;

    @ApiModelProperty("订单行项目类别")
    @Column(name = "pstyv_t", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '订单行项目类别'")
    private String pstyvT;

    @ApiModelProperty("会计凭证")
    @Column(name = "belnr", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '会计凭证'")
    private String belnr;

    @ApiModelProperty("销售订单编号")
    @Column(name = "aubel", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售订单编号'")
    private String aubel;

    @ApiModelProperty("交货单编号")
    @Column(name = "vgbel", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '交货单编号'")
    private String vgbel;

    @ApiModelProperty("商品")
    @Column(name = "arktx", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商品'")
    private String arktx;

    @ApiModelProperty("标准价")
    @Column(name = "netwr_hs", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '标准价'")
    private String netwrHs;

    @ApiModelProperty("实际价")
    @Column(name = "netwr_zk", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '实际价'")
    private String netwrZk;

    @ApiModelProperty("折扣率(%)")
    @Column(name = "ratio", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '折扣率(%)'")
    private String ratio;

    @ApiModelProperty("数量")
    @Column(name = "fkimg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数量'")
    private String fkimg;

    @ApiModelProperty("单位")
    @Column(name = "vrkme", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位'")
    private String vrkme;

    @ApiModelProperty("基本单位数量")
    @Column(name = "fklmg", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '基本单位数量'")
    private String fklmg;

    @ApiModelProperty("基本单位")
    @Column(name = "meins", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '基本单位'")
    private String meins;

    @ApiModelProperty("折扣金额")
    @Column(name = "kzwi6", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '折扣金额'")
    private String kzwi6;

    @ApiModelProperty("应收金额")
    @Column(name = "kzwi1", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '应收金额'")
    private String kzwi1;

    @ApiModelProperty("应收余额")
    @Column(name = "zysye", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '应收余额'")
    private String zysye;

    @ApiModelProperty("随单费用折扣值")
    @Column(name = "zsdfy", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '随单费用折扣值'")
    private String zsdfy;

    @ApiModelProperty("发票固定折扣值")
    @Column(name = "zk01", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票固定折扣值'")
    private String zk01;

    @ApiModelProperty("发票费用折扣值")
    @Column(name = "zfpfy", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '发票费用折扣值'")
    private String zfpfy;

    @ApiModelProperty("商品编号")
    @Column(name = "matnr", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '商品编号'")
    private String matnr;

    @ApiModelProperty("送达方")
    @Column(name = "kunwe", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '送达方'")
    private String kunwe;

    @ApiModelProperty("送达方名称")
    @Column(name = "kunwe_txt", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '送达方名称'")
    private String kunweTxt;

    @ApiModelProperty("客户订单号")
    @Column(name = "bstnk", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户订单号'")
    private String bstnk;

    @ApiModelProperty("利润中心")
    @Column(name = "prctr", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '利润中心'")
    private String prctr;

    @ApiModelProperty("预留字段1")
    @Column(name = "hedi01", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预留字段1'")
    private String hedi01;

    @ApiModelProperty("预留字段2")
    @Column(name = "hedi02", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预留字段2'")
    private String hedi02;

    @ApiModelProperty("预留字段3")
    @Column(name = "hedi03", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预留字段3'")
    private String hedi03;

    @ApiModelProperty("预留字段4")
    @Column(name = "hedi04", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预留字段4'")
    private String hedi04;

    @ApiModelProperty("预留字段5")
    @Column(name = "hedi05", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预留字段5'")
    private String hedi05;
}
