package com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationDocListEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * 活动预付(ReconciliationDocListEntity)表mybatis访问层
 *
 * @author youjun
 * @date 2022年11月15日 19：35
 */
public interface ReconciliationDocListMapper extends BaseMapper<ReconciliationDocListEntity> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param reconciliationDocListDto 查询实体
     * @return 所有数据
     */
    public Page<ReconciliationDocListVo> findByReconciliations(@Param("page") Page<ReconciliationDocListVo> page, @Param("dto") ReconciliationDocListDto reconciliationDocListDto);

    Page<ReconciliationDocListVo> findPageForOut(@Param("page") Page<ReconciliationDocListVo> page, @Param("dto") ReconciliationDocListDto dto);

    List<String> findNotUpdateReconciliationDocList(@Param("dto") ReconciliationDocListDto dto);

    void deleteByCondition(@Param("dto") ReconciliationDocListDto dto);
}
