package com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationJobLogEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationJobLogDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationJobLogVo;
import org.apache.ibatis.annotations.Param;

/**
 * TPM-任务执行日志(ReconciliationJobLog)表数据库访问层
 *
 * @author liuyifan
 * @date 2023-02-22 11:04:03
 */
public interface ReconciliationJobLogMapper extends BaseMapper<ReconciliationJobLogEntity> {

    /**
     * 分页列表
     *
     * @param page
     *            分页信息
     * @param dto
     *            分页参数dto
     * @return 分页列表
     */
    Page<ReconciliationJobLogVo> findByConditions(Page<ReconciliationJobLogVo> page,
                                                  @Param("dto") ReconciliationJobLogDto dto);

}
