package com.biz.crm.tpm.business.reconciliation.doc.list.local.notifier;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationSummaryDataDisplayLogDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.event.log.ReconciliationSummaryDataDisplayLogEventListener;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationSummaryDataDisplayLogVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @ClassName ReconciliationSummaryDataDisplayLogEventListenerImpl
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/30 14:55
 **/
@Component
public class ReconciliationSummaryDataDisplayLogEventListenerImpl implements ReconciliationSummaryDataDisplayLogEventListener {

    @Autowired(required = false)
    private CrmBusinessLogVoService crmBusinessLogVoService;


    @Override
    public void onCreate(ReconciliationSummaryDataDisplayLogDto eventDto) {
        ReconciliationSummaryDataDisplayLogVo newest = eventDto.getNewest();
        ReconciliationSummaryDataDisplayLogVo original = eventDto.getOriginal();
        String onlyKey = newest.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.CREATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onDelete(ReconciliationSummaryDataDisplayLogDto eventDto) {
        ReconciliationSummaryDataDisplayLogVo newest = eventDto.getNewest();
        ReconciliationSummaryDataDisplayLogVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.DELETE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onUpdate(ReconciliationSummaryDataDisplayLogDto eventDto) {
        ReconciliationSummaryDataDisplayLogVo newest = eventDto.getNewest();
        ReconciliationSummaryDataDisplayLogVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setOldObject(original);
        crmBusinessLogDto.setNewObject(newest);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }

    @Override
    public void onEnable(ReconciliationSummaryDataDisplayLogDto eventDto) {
        ReconciliationSummaryDataDisplayLogVo newest = eventDto.getNewest();
        ReconciliationSummaryDataDisplayLogVo original = eventDto.getOriginal();
        String onlyKey = original.getId();
        CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
        crmBusinessLogDto.setOperationType(OperationTypeEunm.UPDATE.getDictCode());
        crmBusinessLogDto.setOnlyKey(onlyKey);
        crmBusinessLogDto.setAppCode(TenantUtils.getTenantCode());
        crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
        //只传单个字段
        JSONObject oldObject = new JSONObject();
        JSONObject newObject = new JSONObject();
        oldObject.put("enableStatus", original.getEnableStatus());
        newObject.put("enableStatus", newest.getEnableStatus());
        crmBusinessLogDto.setOldObject(oldObject);
        crmBusinessLogDto.setNewObject(newObject);
        crmBusinessLogVoService.handleSave(crmBusinessLogDto);
    }
}
