package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;

import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationCorrelationEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationCorrelationMapper;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationCorrelationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationCorrelationVo;
import org.springframework.stereotype.Component;

/**
 * TPM-对账单据关联数据(repository)
 *
 * @author liuyifan
 * @date 2023-02-20 14:51:38
 */
@Component
public class ReconciliationCorrelationRepository
    extends ServiceImpl<ReconciliationCorrelationMapper, ReconciliationCorrelationEntity> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<ReconciliationCorrelationVo> findByConditions(Page<ReconciliationCorrelationVo> page,
                                                              ReconciliationCorrelationDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public ReconciliationCorrelationEntity findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<ReconciliationCorrelationEntity> findByIds(List<String> ids) {
        return this.lambdaQuery().in(ReconciliationCorrelationEntity::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate().in(ReconciliationCorrelationEntity::getId, ids)
            .set(ReconciliationCorrelationEntity::getEnableStatus, enable.getCode()).update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate().in(ReconciliationCorrelationEntity::getId, ids)
            .set(ReconciliationCorrelationEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }
}
