package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationDocListFileEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationDocListFileMapper;
import java.util.List;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListFileDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListFileVo;
import org.springframework.stereotype.Component;

/**
 * TPM-对账单据文件(repository)
 *
 * @author makejava
 * @date 2022-12-10 14:56:48
 */
@Component
public class ReconciliationDocListFileRepository extends ServiceImpl<ReconciliationDocListFileMapper, ReconciliationDocListFileEntity> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<ReconciliationDocListFileVo> findByConditions(Page<ReconciliationDocListFileVo> page, ReconciliationDocListFileDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public ReconciliationDocListFileEntity findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<ReconciliationDocListFileEntity> findByIds(List<String> ids) {
        return this.lambdaQuery().in(ReconciliationDocListFileEntity::getId, ids).list();
    }

    /**
     * 根据关联编码与文件类型查询文件详情vo
     * @param statementCode 关联编码
     * @param fileType 文件类型
     * @return 文件详情vo
     */
    public ReconciliationDocListFileEntity findDetailByStatementCodeAndFileType(String statementCode, String fileType) {
        return this.lambdaQuery()
                .eq(ReconciliationDocListFileEntity::getStatementCode, statementCode)
                .eq(ReconciliationDocListFileEntity::getFileType,fileType)
                .one();
    }
}
