package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationDocListEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationDocListMapper;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationDocListDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationDocListVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@Component
public class ReconciliationDocListRepository extends ServiceImpl<ReconciliationDocListMapper, ReconciliationDocListEntity> {

    @Resource
    private ReconciliationDocListMapper reconciliationDocListMapper;

    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param reconciliationDocListDto 实体对象
     * @return
     */
    public Page<ReconciliationDocListVo> findByReconciliations(Pageable pageable, ReconciliationDocListDto reconciliationDocListDto) {
        Page<ReconciliationDocListVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<ReconciliationDocListVo> pageList = this.reconciliationDocListMapper.findByReconciliations(page, reconciliationDocListDto);
        return pageList;
    }


    /**
     * 根据id查询列表
     * @param ids 主键id列表
     * @return  对账单实体集合
     */
    public List<ReconciliationDocListEntity> findByIds(List<String>  ids) {
        return this.lambdaQuery().eq(ReconciliationDocListEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationDocListEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(UuidEntity::getId,ids)
                .list();
    }

    /**
     * 根据合同编码查询
     * @param contractId 合同编码
     * @return 对账单
     */
    public ReconciliationDocListEntity findByContractId(String contractId) {
        Validate.notNull(contractId,"合同编码不能为空");
        return this.lambdaQuery()
                .eq(ReconciliationDocListEntity::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationDocListEntity::getTenantCode,TenantUtils.getTenantCode())
                .eq(ReconciliationDocListEntity::getContractId,contractId)
                .one();

    }

    public Page<ReconciliationDocListVo> findPageForOut(Pageable pageable, ReconciliationDocListDto dto) {
        Page<ReconciliationDocListVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.baseMapper.findPageForOut(page, dto);
    }

    public List<String> findNotUpdateReconciliationDocList(ReconciliationDocListDto dto) {
        return baseMapper.findNotUpdateReconciliationDocList(dto);
    }

    public void deleteByCondition(ReconciliationDocListDto dto) {
        this.baseMapper.deleteByCondition(dto);
    }
}
