package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationJobLogEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationJobLogMapper;

import java.util.List;

import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.ReconciliationJobLogDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.ReconciliationJobLogVo;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * TPM-任务执行日志(repository)
 *
 * @author liuyifan
 * @date 2023-02-22 11:04:04
 */
@Component
public class ReconciliationJobLogRepository extends ServiceImpl<ReconciliationJobLogMapper, ReconciliationJobLogEntity> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<ReconciliationJobLogVo> findByConditions(Page<ReconciliationJobLogVo> page,
                                                         ReconciliationJobLogDto dto) {
        return this.baseMapper.findByConditions(page, dto);
    }

    public ReconciliationJobLogEntity findById(String id) {
        return this.baseMapper.selectById(id);
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param ids
     * @return
     */
    public List<ReconciliationJobLogEntity> findByIds(List<String> ids) {
        return this.lambdaQuery().in(ReconciliationJobLogEntity::getId, ids).list();
    }

    /**
     * 根据id集合 更新组织启用/禁用状态
     *
     * @param ids
     * @param enable
     */
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        this.lambdaUpdate().in(ReconciliationJobLogEntity::getId, ids)
                .set(ReconciliationJobLogEntity::getEnableStatus, enable.getCode()).update();
    }

    /**
     * 逻辑删除
     *
     * @param ids
     */
    public void updateDelFlagByIds(List<String> ids) {
        this.lambdaUpdate().in(ReconciliationJobLogEntity::getId, ids)
                .set(ReconciliationJobLogEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
    }

    /**
     * 找到独特job信息
     *
     * @param dto dto
     * @return {@link ReconciliationJobLogEntity}
     */
    public ReconciliationJobLogEntity findUniqueJobInfo(ReconciliationJobLogDto dto) {
        //在几个字段说唯一联合索引，只会查出来一条
        return this.lambdaQuery()
                .eq(ReconciliationJobLogEntity::getBusinessFormatCode, dto.getBusinessFormatCode())
                .eq(ReconciliationJobLogEntity::getBusinessUnitCode, dto.getBusinessUnitCode())
                .eq(ReconciliationJobLogEntity::getStartDate, dto.getStartDate())
                .eq(ReconciliationJobLogEntity::getEndDate, dto.getEndDate())
                .eq(ReconciliationJobLogEntity::getAccountReconciliationRuleCode, dto.getAccountReconciliationRuleCode())
                .one();
    }
}
