package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailHeadApproveEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationSummaryDataDisplayDetailHeadApproveMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName ReconciliationSummaryDataDisplayDetailHeadApproveRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 16:42
 **/
@Component
public class ReconciliationSummaryDataDisplayDetailHeadApproveRepository extends ServiceImpl<ReconciliationSummaryDataDisplayDetailHeadApproveMapper, ReconciliationSummaryDataDisplayDetailHeadApproveEntity> {

    public List<ReconciliationSummaryDataDisplayDetailHeadApproveEntity> findByStatementCode(String statementCode){
        if (StringUtils.isEmpty(statementCode)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(ReconciliationSummaryDataDisplayDetailHeadApproveEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadApproveEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadApproveEntity::getStatementCode, statementCode)
                .list();
    }

    public void deleteByStatementCode(String statementCode){
        if (StringUtils.isEmpty(statementCode)){
            return;
        }
        this.lambdaUpdate()
                .eq(ReconciliationSummaryDataDisplayDetailHeadApproveEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadApproveEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadApproveEntity::getStatementCode, statementCode)
                .remove();
    }

    public Integer getExportTotalCount(String statementCode){
        return this.lambdaQuery()
                .eq(ReconciliationSummaryDataDisplayDetailHeadApproveEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadApproveEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadApproveEntity::getStatementCode, statementCode)
                .count();
    }


}
