package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailHeadApproveEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailHeadAuditEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationSummaryDataDisplayDetailHeadApproveMapper;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationSummaryDataDisplayDetailHeadAuditMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName ReconciliationSummaryDataDisplayDetailHeadApproveRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 16:42
 **/
@Component
public class ReconciliationSummaryDataDisplayDetailHeadAuditRepository extends ServiceImpl<ReconciliationSummaryDataDisplayDetailHeadAuditMapper, ReconciliationSummaryDataDisplayDetailHeadAuditEntity> {

    public List<ReconciliationSummaryDataDisplayDetailHeadAuditEntity> findByStatementCode(String statementCode){
        if (StringUtils.isEmpty(statementCode)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(ReconciliationSummaryDataDisplayDetailHeadAuditEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadAuditEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadAuditEntity::getStatementCode, statementCode)
                .list();
    }

    public Integer getExportTotalCount(String statementCode){
        if (StringUtils.isEmpty(statementCode)){
            return 0;
        }
        return this.lambdaQuery()
                .eq(ReconciliationSummaryDataDisplayDetailHeadAuditEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadAuditEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadAuditEntity::getStatementCode, statementCode)
                .count();
    }

    public void deleteByStatementCode(String statementCode){
        if (StringUtils.isEmpty(statementCode)){
            return;
        }
        this.lambdaUpdate()
                .eq(ReconciliationSummaryDataDisplayDetailHeadAuditEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadAuditEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailHeadAuditEntity::getStatementCode, statementCode)
                .remove();

    }

}
