package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailHeadApproveEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailSubApproveEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationSummaryDataDisplayDetailHeadApproveMapper;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationSummaryDataDisplayDetailSubApproveMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName ReconciliationSummaryDataDisplayDetailHeadApproveRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 16:42
 **/
@Component
public class ReconciliationSummaryDataDisplayDetailSubApproveRepository extends ServiceImpl<ReconciliationSummaryDataDisplayDetailSubApproveMapper, ReconciliationSummaryDataDisplayDetailSubApproveEntity> {

    public List<ReconciliationSummaryDataDisplayDetailSubApproveEntity> findByStatementCode(String statementCode){
        if (StringUtils.isEmpty(statementCode)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(ReconciliationSummaryDataDisplayDetailSubApproveEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubApproveEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubApproveEntity::getStatementCode, statementCode)
                .list();
    }

    public void deleteByStatementCode(String statementCode) {
        if (org.apache.commons.lang3.StringUtils.isEmpty(statementCode)) {
            return;
        }
        this.lambdaUpdate()
                .eq(ReconciliationSummaryDataDisplayDetailSubApproveEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubApproveEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubApproveEntity::getStatementCode, statementCode)
                .remove();
    }

    public Integer getExportTotalCount(String statementCode){
        if (StringUtils.isEmpty(statementCode)){
            return 0;
        }
        return this.lambdaQuery()
                .eq(ReconciliationSummaryDataDisplayDetailSubApproveEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubApproveEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubApproveEntity::getStatementCode, statementCode)
                .count();
    }


}
