package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailSubApproveEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailSubAuditEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayDetailSubCommunicateEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationSummaryDataDisplayDetailSubApproveMapper;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationSummaryDataDisplayDetailSubCommunicateMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName ReconciliationSummaryDataDisplayDetailHeadApproveRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/6/7 16:42
 **/
@Component
public class ReconciliationSummaryDataDisplayDetailSubCommunicateRepository extends ServiceImpl<ReconciliationSummaryDataDisplayDetailSubCommunicateMapper, ReconciliationSummaryDataDisplayDetailSubCommunicateEntity> {

    public List<ReconciliationSummaryDataDisplayDetailSubCommunicateEntity> findByStatementCode(String statementCode) {
        if (StringUtils.isEmpty(statementCode)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(ReconciliationSummaryDataDisplayDetailSubCommunicateEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubCommunicateEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubCommunicateEntity::getStatementCode, statementCode)
                .list();
    }

    public void deleteByStatementCode(String statementCode) {
        if (org.apache.commons.lang3.StringUtils.isEmpty(statementCode)) {
            return;
        }
        this.lambdaUpdate()
                .eq(ReconciliationSummaryDataDisplayDetailSubCommunicateEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubCommunicateEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubCommunicateEntity::getStatementCode, statementCode)
                .remove();
    }

    public Integer getExportTotalCount(String statementCode){
        if (StringUtils.isEmpty(statementCode)){
            return 0;
        }
        return this.lambdaQuery()
                .eq(ReconciliationSummaryDataDisplayDetailSubCommunicateEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubCommunicateEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayDetailSubCommunicateEntity::getStatementCode, statementCode)
                .count();
    }

}