package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.ReconciliationSummaryDataDisplayEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.ReconciliationSummaryDataDisplayMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @ClassName ReconciliationSummaryDataDisplayRepository
 * @Description
 * @AUTHOR WangJJ
 * @DATE 2023/5/24 15:51
 **/
@Component
public class ReconciliationSummaryDataDisplayRepository extends ServiceImpl<ReconciliationSummaryDataDisplayMapper, ReconciliationSummaryDataDisplayEntity> {

    public ReconciliationSummaryDataDisplayEntity findById(String id){
        if (StringUtils.isEmpty(id)){
            return null;
        }
        return this.lambdaQuery()
                .eq(ReconciliationSummaryDataDisplayEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ReconciliationSummaryDataDisplayEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(ReconciliationSummaryDataDisplayEntity::getId, id)
                .one();
    }

}
