package com.biz.crm.tpm.business.reconciliation.doc.list.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.entity.SapReconciliationEntity;
import com.biz.crm.tpm.business.reconciliation.doc.list.local.mapper.SapReconciliationMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.PullSapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.dto.SapReconciliationDto;
import com.biz.crm.tpm.business.reconciliation.doc.list.sdk.vo.SapReconciliationVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;
import java.util.Set;

@Component
public class SapReconciliationRepository extends ServiceImpl<SapReconciliationMapper, SapReconciliationEntity> {

    @Resource
    private SapReconciliationMapper sapReconciliationMapper;

    public Page<SapReconciliationVo> findByReconciliations(Pageable pageable, SapReconciliationDto sapReconciliationDto) {
        Page<SapReconciliationVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<SapReconciliationVo> pageList = this.sapReconciliationMapper.findByReconciliations(page, sapReconciliationDto);
        return pageList;
    }

    public Set<String> findCustomer(SapReconciliationDto dto) {
        return sapReconciliationMapper.findCustomer(dto);
    }

    public List<SapReconciliationEntity> findListByCustomerCode(SapReconciliationDto dto) {
        return this.sapReconciliationMapper.findListByCustomerCode(dto);
    }

    public void deleteByDate(PullSapReconciliationDto dto) {
        this.lambdaUpdate()
                .set(SapReconciliationEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
                .eq(SapReconciliationEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(SapReconciliationEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(StringUtils.isNotBlank(dto.getPrctr()),SapReconciliationEntity::getPrctr,dto.getPrctr())
                .eq(StringUtils.isNotBlank(dto.getVkorg()),SapReconciliationEntity::getVkorg,dto.getVkorg())
                .eq(StringUtils.isNotBlank(dto.getVtweg()),SapReconciliationEntity::getVtweg,dto.getVtweg())
                .between(SapReconciliationEntity::getFkdat,dto.getStartDate(),dto.getEndDate())
                .update();
    }
}
